/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.neo4j.driver.internal.InternalRecordAccessor;
import org.neo4j.driver.internal.PeekingIterator;
import org.neo4j.driver.v1.Function;
import org.neo4j.driver.v1.Pair;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.RecordAccessor;
import org.neo4j.driver.v1.Records;
import org.neo4j.driver.v1.ResultCursor;
import org.neo4j.driver.v1.ResultSummary;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.NoRecordException;

public class InternalResultCursor
extends InternalRecordAccessor
implements ResultCursor {
    private final List<String> keys;
    private final PeekingIterator<Record> iter;
    private final ResultSummary summary;
    private boolean open = true;
    private Record current = null;
    private long position = -1L;
    private long limit = -1L;

    public InternalResultCursor(List<String> keys, List<Record> body, ResultSummary summary) {
        this.keys = keys;
        this.iter = new PeekingIterator<Record>(body.iterator());
        this.summary = summary;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public Value value(int index) {
        return this.record().value(index);
    }

    @Override
    public Value value(String key) {
        return this.record().value(key);
    }

    @Override
    public boolean containsKey(String key) {
        return this.keys.contains(key);
    }

    @Override
    public int index(String key) {
        return this.record().index(key);
    }

    @Override
    public List<String> keys() {
        return this.keys;
    }

    @Override
    public int size() {
        return this.keys.size();
    }

    @Override
    public boolean hasRecord() {
        this.assertOpen();
        return this.current != null && this.current.hasRecord();
    }

    @Override
    public Record record() {
        if (this.hasRecord()) {
            return this.current;
        }
        throw new NoRecordException("In order to access the fields of a record in a result, you must first call next() to point the result to the next record in the result stream.");
    }

    @Override
    public long position() {
        this.assertOpen();
        return this.position;
    }

    @Override
    public boolean atEnd() {
        this.assertOpen();
        return !this.iter.hasNext();
    }

    @Override
    public boolean next() {
        this.assertOpen();
        if (this.iter.hasNext()) {
            this.current = this.iter.next();
            ++this.position;
            if (this.position == this.limit) {
                this.discard();
            }
            return true;
        }
        return false;
    }

    @Override
    public long skip(long elements) {
        if (elements < 0L) {
            throw new ClientException("Cannot skip negative number of elements");
        }
        int skipped = 0;
        while ((long)skipped < elements && this.next()) {
            ++skipped;
        }
        return skipped;
    }

    @Override
    public long limit(long records) {
        if (records < 0L) {
            throw new ClientException("Cannot limit negative number of elements");
        }
        if (records == 0L) {
            this.limit = this.position;
            this.discard();
        } else {
            this.limit = records + this.position;
        }
        return this.limit;
    }

    @Override
    public boolean first() {
        long pos = this.position();
        return pos < 0L ? this.next() : pos == 0L;
    }

    @Override
    public boolean single() {
        return this.first() && this.atEnd();
    }

    @Override
    public RecordAccessor peek() {
        return new PeekingRecordAccessor();
    }

    @Override
    public List<Record> list() {
        return this.list(Records.recordAsIs());
    }

    @Override
    public <T> List<T> list(Function<RecordAccessor, T> mapFunction) {
        if (this.isEmpty()) {
            this.assertOpen();
            return Collections.emptyList();
        }
        if (this.first()) {
            ArrayList<T> result = new ArrayList<T>();
            do {
                result.add(mapFunction.apply(this));
            } while (this.next());
            this.discard();
            return result;
        }
        throw new ClientException(String.format("Can't retain records when cursor is not pointing at the first record (currently at position %d)", this.position));
    }

    @Override
    public ResultSummary summarize() {
        while (this.next()) {
        }
        this.discard();
        return this.summary;
    }

    @Override
    public void close() {
        if (!this.open) {
            throw new ClientException("Already closed");
        }
        this.discard();
        this.open = false;
    }

    private void assertOpen() {
        if (!this.open) {
            throw new ClientException("Cursor already closed");
        }
    }

    private boolean isEmpty() {
        return this.position == -1L && !this.iter.hasNext();
    }

    private void discard() {
        this.iter.discard();
    }

    private class PeekingRecordAccessor
    implements RecordAccessor {
        private PeekingRecordAccessor() {
        }

        @Override
        public List<String> keys() {
            return InternalResultCursor.this.keys();
        }

        @Override
        public boolean containsKey(String key) {
            return InternalResultCursor.this.containsKey(key);
        }

        @Override
        public int index(String key) {
            return InternalResultCursor.this.index(key);
        }

        @Override
        public Value value(String key) {
            return this.record().value(key);
        }

        @Override
        public int size() {
            return InternalResultCursor.this.size();
        }

        @Override
        public List<Pair<String, Value>> fields() {
            return this.record().fields();
        }

        @Override
        public boolean hasRecord() {
            return InternalResultCursor.this.iter.hasNext();
        }

        @Override
        public Record record() {
            Record record = (Record)InternalResultCursor.this.iter.peek();
            if (record == null) {
                throw new NoRecordException("Cannot peek past last record");
            }
            return record;
        }

        @Override
        public Value value(int index) {
            return this.record().value(index);
        }
    }
}

