/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Map;
import org.neo4j.driver.internal.AsValue;
import org.neo4j.driver.internal.util.Extract;
import org.neo4j.driver.internal.util.Iterables;
import org.neo4j.driver.internal.value.MapValue;
import org.neo4j.driver.v1.Entity;
import org.neo4j.driver.v1.Function;
import org.neo4j.driver.v1.Identity;
import org.neo4j.driver.v1.Pair;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.Values;

public abstract class InternalEntity
implements Entity,
AsValue {
    private final Identity id;
    private final Map<String, Value> properties;

    public InternalEntity(Identity id, Map<String, Value> properties) {
        this.id = id;
        this.properties = properties;
    }

    @Override
    public Identity identity() {
        return this.id;
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    @Override
    public Value asValue() {
        return new MapValue(this.properties);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalEntity that = (InternalEntity)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "Entity{id=" + this.id + ", properties=" + this.properties + '}';
    }

    @Override
    public boolean containsKey(String key) {
        return this.properties.containsKey(key);
    }

    @Override
    public Iterable<String> keys() {
        return this.properties.keySet();
    }

    @Override
    public Value value(String key) {
        Value value = this.properties.get(key);
        return value == null ? Values.NULL : value;
    }

    @Override
    public Iterable<Value> values() {
        return this.properties.values();
    }

    @Override
    public <T> Iterable<T> values(Function<Value, T> mapFunction) {
        return Iterables.map(this.properties.values(), mapFunction);
    }

    @Override
    public Iterable<Pair<String, Value>> properties() {
        return this.properties(Values.valueAsIs());
    }

    @Override
    public <V> Iterable<Pair<String, V>> properties(Function<Value, V> Function2) {
        return Extract.properties(this, Function2);
    }
}

