/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.neo4j.driver.Function;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.value.ValueAdapter;

public class ListValue
extends ValueAdapter {
    private final Value[] values;

    public ListValue(Value ... values) {
        this.values = values;
    }

    @Override
    public boolean javaBoolean() {
        return this.values.length > 0;
    }

    @Override
    public <T> List<T> javaList(Function<Value, T> mapFunction) {
        ArrayList<T> list = new ArrayList<T>(this.values.length);
        for (Value value : this.values) {
            list.add(mapFunction.apply(value));
        }
        return list;
    }

    @Override
    public boolean isList() {
        return true;
    }

    @Override
    public long size() {
        return this.values.length;
    }

    @Override
    public Value get(long index) {
        return this.values[(int)index];
    }

    @Override
    public Iterator<Value> iterator() {
        return new Iterator<Value>(){
            private int cursor = 0;

            @Override
            public boolean hasNext() {
                return this.cursor < ListValue.this.values.length;
            }

            @Override
            public Value next() {
                return ListValue.this.values[this.cursor++];
            }

            @Override
            public void remove() {
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListValue values1 = (ListValue)o;
        return Arrays.equals(this.values, values1.values);
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    @Override
    public String toString() {
        return "ListValue" + Arrays.toString(this.values) + "";
    }
}

