/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import org.neo4j.driver.internal.value.ValueAdapter;

public class FloatValue
extends ValueAdapter {
    private final double val;

    public FloatValue(double val) {
        this.val = val;
    }

    @Override
    public String javaString() {
        return Double.toString(this.val);
    }

    @Override
    public int javaInteger() {
        return (int)this.val;
    }

    @Override
    public long javaLong() {
        return (long)this.val;
    }

    @Override
    public float javaFloat() {
        return (float)this.val;
    }

    @Override
    public boolean javaBoolean() {
        return this.val != 0.0;
    }

    @Override
    public double javaDouble() {
        return this.val;
    }

    @Override
    public boolean isFloat() {
        return true;
    }

    @Override
    public String toString() {
        return "float<" + this.val + ">";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FloatValue values = (FloatValue)o;
        return Double.compare(values.val, this.val) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.val);
        return (int)(temp ^ temp >>> 32);
    }
}

