/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import org.neo4j.driver.internal.value.ValueAdapter;

public class BooleanValue
extends ValueAdapter {
    private final boolean val;

    public BooleanValue(boolean val) {
        this.val = val;
    }

    @Override
    public boolean javaBoolean() {
        return this.val;
    }

    @Override
    public String javaString() {
        return this.val ? "true" : "false";
    }

    @Override
    public int javaInteger() {
        return this.val ? 1 : 0;
    }

    @Override
    public long javaLong() {
        return this.val ? 1L : 0L;
    }

    @Override
    public float javaFloat() {
        return this.val ? 1.0f : 0.0f;
    }

    @Override
    public double javaDouble() {
        return this.val ? 1.0 : 0.0;
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BooleanValue values = (BooleanValue)o;
        return this.val == values.val;
    }

    public int hashCode() {
        return this.javaInteger();
    }
}

