/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.summary;

import org.neo4j.driver.Function;
import org.neo4j.driver.InputPosition;
import org.neo4j.driver.Notification;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.summary.SimpleInputPosition;

public class SimpleNotification
implements Notification {
    public static final Function<Value, Notification> VALUE_TO_NOTIFICATION = new Function<Value, Notification>(){

        @Override
        public Notification apply(Value value) {
            String code = value.get("code").javaString();
            String title = value.get("title").javaString();
            String description = value.get("description").javaString();
            Value posValue = value.get("position");
            SimpleInputPosition position = null;
            if (posValue != null) {
                position = new SimpleInputPosition(posValue.get("offset").javaInteger(), posValue.get("line").javaInteger(), posValue.get("column").javaInteger());
            }
            SimpleNotification notification = new SimpleNotification(code, title, description, position);
            return notification;
        }
    };
    private final String code;
    private final String title;
    private final String description;
    private final InputPosition position;

    public SimpleNotification(String code, String title, String description, InputPosition position) {
        this.code = code;
        this.title = title;
        this.description = description;
        this.position = position;
    }

    @Override
    public String code() {
        return this.code;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public InputPosition position() {
        return this.position;
    }

    public String toString() {
        String info = "code=" + this.code + ", title=" + this.title + ", description=" + this.description;
        return this.position == null ? info : info + ", position={" + this.position + "}";
    }
}

