/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.connector.socket;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import org.neo4j.driver.Config;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.Version;
import org.neo4j.driver.internal.connector.socket.SocketConnection;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.Connector;

public class SocketConnector
implements Connector {
    @Override
    public boolean supports(String scheme) {
        return scheme.equals("bolt");
    }

    @Override
    public Connection connect(URI sessionURI, Config config) throws ClientException {
        int port = sessionURI.getPort() == -1 ? 7687 : sessionURI.getPort();
        SocketConnection conn = new SocketConnection(sessionURI.getHost(), port, config);
        conn.init("bolt-java-driver/" + Version.driverVersion());
        return conn;
    }

    @Override
    public Collection<String> supportedSchemes() {
        return Arrays.asList("bolt");
    }
}

