/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.connector.socket;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.SocketChannel;
import java.security.GeneralSecurityException;
import java.util.List;
import org.neo4j.driver.Config;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.connector.socket.AllOrNothingChannel;
import org.neo4j.driver.internal.connector.socket.LoggingByteChannel;
import org.neo4j.driver.internal.connector.socket.SSLSocketChannel;
import org.neo4j.driver.internal.connector.socket.SocketProtocol;
import org.neo4j.driver.internal.connector.socket.SocketProtocolV1;
import org.neo4j.driver.internal.connector.socket.SocketResponseHandler;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.internal.spi.Logger;

public class SocketClient {
    private final String host;
    private final int port;
    private final Logger logger;
    protected final Config config;
    private SocketProtocol protocol;
    private MessageFormat.Reader reader;
    private MessageFormat.Writer writer;
    private ByteChannel channel;

    public SocketClient(String host, int port, Config config, Logger logger) {
        this.host = host;
        this.port = port;
        this.config = config;
        this.logger = logger;
        this.channel = null;
    }

    public void start() {
        try {
            this.logger.debug("~~ [CONNECT] %s:%d.", this.host, this.port);
            this.channel = ChannelFactory.create(this.host, this.port, this.config, this.logger);
            this.protocol = this.negotiateProtocol();
            this.reader = this.protocol.reader();
            this.writer = this.protocol.writer();
        }
        catch (ConnectException e) {
            throw new ClientException(String.format("Unable to connect to '%s' on port %s, ensure the database is running and that there is a working network connection to it.", this.host, this.port));
        }
        catch (IOException e) {
            throw new ClientException("Unable to process request: " + e.getMessage(), e);
        }
        catch (GeneralSecurityException e) {
            throw new ClientException("Unable to establish ssl connection with server: " + e.getMessage(), e);
        }
    }

    public void send(List<Message> pendingMessages, SocketResponseHandler handler) throws IOException {
        for (Message message : pendingMessages) {
            this.writer.write(message);
        }
        this.writer.flush();
        while (handler.receivedResponses() < pendingMessages.size()) {
            this.reader.read(handler);
        }
    }

    public void stop() {
        block2: {
            try {
                this.channel.close();
                this.channel = null;
                this.logger.debug("~~ [CLOSE]", new Object[0]);
            }
            catch (IOException e) {
                if (e.getMessage().equals("An existing connection was forcibly closed by the remote host")) break block2;
                throw new ClientException("Unable to close socket connection properly." + e.getMessage(), e);
            }
        }
    }

    private SocketProtocol negotiateProtocol() throws IOException {
        this.logger.debug("~~ [HANDSHAKE] [1, 0, 0, 0].", new Object[0]);
        ByteBuffer buf = ByteBuffer.wrap(new byte[]{0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        this.channel.write(buf);
        buf.clear();
        buf.limit(4);
        this.channel.read(buf);
        buf.flip();
        int proposal = buf.getInt();
        switch (proposal) {
            case 1: {
                this.logger.debug("~~ [HANDSHAKE] 1", new Object[0]);
                return new SocketProtocolV1(this.channel);
            }
            case 0: {
                throw new ClientException("The server does not support any of the protocol versions supported by this driver. Ensure that you are using driver and server versions that are compatible with one another.");
            }
        }
        throw new ClientException("Protocol error, server suggested unexpected protocol version: " + proposal);
    }

    public String toString() {
        int version = this.protocol == null ? -1 : this.protocol.version();
        return "SocketClient[protocolVersion=" + version + "]";
    }

    private static class ChannelFactory {
        private ChannelFactory() {
        }

        public static ByteChannel create(String host, int port, Config config, Logger logger) throws IOException, GeneralSecurityException {
            SocketChannel soChannel = SocketChannel.open();
            soChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
            soChannel.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)true);
            soChannel.connect(new InetSocketAddress(host, port));
            ByteChannel channel = null;
            channel = config.isTlsEnabled() ? new SSLSocketChannel(host, port, soChannel, logger, config.tlsAuthConfig()) : new AllOrNothingChannel(soChannel);
            if (logger.isTraceEnabled()) {
                channel = new LoggingByteChannel(channel, logger);
            }
            return channel;
        }
    }
}

