/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.neo4j.driver.Entity;
import org.neo4j.driver.Identity;
import org.neo4j.driver.Node;
import org.neo4j.driver.Path;
import org.neo4j.driver.Relationship;

public class SimplePath
implements Path {
    private final List<Node> nodes;
    private final List<Relationship> relationships;
    private final List<Path.Segment> segments;

    private static boolean isEndpoint(Node node, Relationship relationship) {
        return node.identity().equals(relationship.start()) || node.identity().equals(relationship.end());
    }

    public SimplePath(List<Entity> alternatingNodeAndRel) {
        this.nodes = new ArrayList<Node>(alternatingNodeAndRel.size() / 2 + 1);
        this.relationships = new ArrayList<Relationship>(alternatingNodeAndRel.size() / 2);
        this.segments = new ArrayList<Path.Segment>(alternatingNodeAndRel.size() / 2);
        if (alternatingNodeAndRel.size() % 2 == 0) {
            throw new IllegalArgumentException("An odd number of entities are required to build a path");
        }
        Node lastNode = null;
        Relationship lastRelationship = null;
        int index = 0;
        for (Entity entity : alternatingNodeAndRel) {
            if (entity == null) {
                throw new IllegalArgumentException("Path entities cannot be null");
            }
            if (index % 2 == 0) {
                try {
                    lastNode = (Node)entity;
                    if (!this.nodes.isEmpty() && !SimplePath.isEndpoint(lastNode, lastRelationship)) {
                        throw new IllegalArgumentException("Node argument " + index + " is not an endpoint of relationship argument " + (index - 1));
                    }
                    this.nodes.add(lastNode);
                }
                catch (ClassCastException e) {
                    String cls = entity.getClass().getName();
                    throw new IllegalArgumentException("Expected argument " + index + " to be a node " + index + " but found a " + cls + " " + "instead");
                }
            }
            try {
                lastRelationship = (Relationship)entity;
                if (!SimplePath.isEndpoint(lastNode, lastRelationship)) {
                    throw new IllegalArgumentException("Node argument " + (index - 1) + " is not an endpoint of relationship argument " + index);
                }
                this.relationships.add(lastRelationship);
            }
            catch (ClassCastException e) {
                String cls = entity.getClass().getName();
                throw new IllegalArgumentException("Expected argument " + index + " to be a relationship but found a " + cls + " instead");
            }
            ++index;
        }
        this.buildSegments();
    }

    public SimplePath(Entity ... alternatingNodeAndRel) {
        this(Arrays.asList(alternatingNodeAndRel));
    }

    public SimplePath(List<Path.Segment> segments, List<Node> nodes, List<Relationship> relationships) {
        this.segments = segments;
        this.nodes = nodes;
        this.relationships = relationships;
    }

    @Override
    public long length() {
        return this.relationships.size();
    }

    @Override
    public boolean contains(Node node) {
        return this.nodes.contains(node);
    }

    @Override
    public boolean contains(Relationship relationship) {
        return this.relationships.contains(relationship);
    }

    @Override
    public Iterable<Node> nodes() {
        return this.nodes;
    }

    @Override
    public Iterable<Relationship> relationships() {
        return this.relationships;
    }

    @Override
    public Node start() {
        return this.nodes.get(0);
    }

    @Override
    public Node end() {
        return this.nodes.get(this.nodes.size() - 1);
    }

    @Override
    public Iterator<Path.Segment> iterator() {
        return this.segments.iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimplePath segments1 = (SimplePath)o;
        return this.segments.equals(segments1.segments);
    }

    public int hashCode() {
        return this.segments.hashCode();
    }

    public String toString() {
        return "Path[" + this.segments + ']';
    }

    private void buildSegments() {
        for (int i = 0; i < this.relationships.size(); ++i) {
            this.segments.add(new SelfContainedSegment(this.nodes.get(i), this.relationships.get(i), this.nodes.get(i + 1)));
        }
    }

    public static class SelfContainedSegment
    implements Path.Segment {
        private final Node start;
        private final Relationship relationship;
        private final Node end;

        public SelfContainedSegment(Node start, Relationship relationship, Node end) {
            this.start = start;
            this.relationship = relationship;
            this.end = end;
        }

        @Override
        public Node start() {
            return this.start;
        }

        @Override
        public Relationship relationship() {
            return this.relationship;
        }

        @Override
        public Node end() {
            return this.end;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            SelfContainedSegment that = (SelfContainedSegment)other;
            return this.start.equals(that.start) && this.end.equals(that.end) && this.relationship.equals(that.relationship);
        }

        public int hashCode() {
            int result = this.start.hashCode();
            result = 31 * result + this.relationship.hashCode();
            result = 31 * result + this.end.hashCode();
            return result;
        }

        public String toString() {
            return String.format(((Identity)this.relationship.start()).equals(this.start.identity()) ? "(%s)-[%s:%s]->(%s)" : "(%s)<-[%s:%s]-(%s)", this.start.identity(), this.relationship.identity(), this.relationship.type(), this.end.identity());
        }
    }
}

