/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Collection;
import java.util.Map;
import org.neo4j.driver.Entity;
import org.neo4j.driver.Identity;
import org.neo4j.driver.Value;

public abstract class SimpleEntity
implements Entity {
    private final Identity id;
    private final Map<String, Value> properties;

    public SimpleEntity(Identity id, Map<String, Value> properties) {
        this.id = id;
        this.properties = properties;
    }

    @Override
    public Identity identity() {
        return this.id;
    }

    public Collection<String> propertyKeys() {
        return this.properties.keySet();
    }

    @Override
    public Value property(String key) {
        return this.properties.get(key);
    }

    @Override
    public int propertyCount() {
        return this.properties.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleEntity that = (SimpleEntity)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "Entity{id=" + this.id + ", properties=" + this.properties + '}';
    }
}

