/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.springframework.boot.autoconfigure;

import java.util.Collection;
import java.util.List;
import org.neo4j.driver.Driver;
import org.neo4j.ogm.config.AutoIndexMode;
import org.neo4j.ogm.drivers.bolt.driver.BoltDriver;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.session.event.EventListener;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.neo4j.Neo4jProperties;
import org.springframework.boot.autoconfigure.domain.EntityScanPackages;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={Driver.class})
@ConditionalOnMissingBean(value={SessionFactory.class})
@ConditionalOnClass(value={SessionFactory.class, BoltDriver.class})
@EnableConfigurationProperties(value={Neo4jProperties.class})
class AdditionalDataConfiguration {
    AdditionalDataConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    public org.neo4j.ogm.config.Configuration configuration(Neo4jProperties properties) {
        return properties.createConfiguration();
    }

    @Bean
    @ConditionalOnMissingBean
    public BoltDriver ogmDriver(org.neo4j.ogm.config.Configuration ogmConfiguration, Driver nativeDriver) {
        BoltDriver boltDriver = new BoltDriver(nativeDriver){

            public synchronized void close() {
            }
        };
        boltDriver.configure(ogmConfiguration);
        return boltDriver;
    }

    @Bean
    @ConditionalOnBean(value={BoltDriver.class})
    public SessionFactory sessionFactory(org.neo4j.ogm.config.Configuration configuration, BoltDriver ogmDriver, ApplicationContext applicationContext, ObjectProvider<EventListener> eventListenerProvider) {
        String[] packagesToScan = this.getPackagesToScan(applicationContext);
        SessionFactory sessionFactory = new SessionFactory((org.neo4j.ogm.driver.Driver)ogmDriver, packagesToScan);
        if (configuration.getAutoIndex() != AutoIndexMode.NONE) {
            sessionFactory.runAutoIndexManager(configuration);
        }
        eventListenerProvider.stream().forEach(arg_0 -> ((SessionFactory)sessionFactory).register(arg_0));
        return sessionFactory;
    }

    private String[] getPackagesToScan(ApplicationContext applicationContext) {
        List packages = EntityScanPackages.get((BeanFactory)applicationContext).getPackageNames();
        if (packages.isEmpty() && AutoConfigurationPackages.has((BeanFactory)applicationContext)) {
            packages = AutoConfigurationPackages.get((BeanFactory)applicationContext);
        }
        return StringUtils.toStringArray((Collection)packages);
    }
}

