/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.terminal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.jline.reader.Completer;
import org.jline.reader.Expander;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.Parser;
import org.jline.reader.impl.completer.NullCompleter;
import org.jline.reader.impl.history.DefaultHistory;
import org.jline.terminal.Attributes;
import org.jline.terminal.TerminalBuilder;
import org.neo4j.shell.log.Logger;
import org.neo4j.shell.parser.ShellStatementParser;
import org.neo4j.shell.terminal.CypherJlineParser;
import org.neo4j.shell.terminal.CypherShellTerminal;
import org.neo4j.shell.terminal.JlineTerminal;
import org.neo4j.shell.terminal.WriteOnlyCypherShellTerminal;
import org.neo4j.util.VisibleForTesting;

public class CypherShellTerminalBuilder {
    private Logger logger;
    private OutputStream out;
    private InputStream in;
    private boolean isInteractive = true;
    private boolean dumb;

    public CypherShellTerminalBuilder interactive(boolean isInteractive) {
        this.isInteractive = isInteractive;
        return this;
    }

    public CypherShellTerminalBuilder logger(Logger logger) {
        this.logger = logger;
        return this;
    }

    @VisibleForTesting
    public CypherShellTerminalBuilder streams(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
        return this;
    }

    @VisibleForTesting
    public CypherShellTerminalBuilder dumb() {
        this.dumb = true;
        return this;
    }

    public CypherShellTerminal build() {
        assert (this.logger != null);
        try {
            return this.isInteractive ? this.buildJlineBasedTerminal() : this.nonInteractiveTerminal();
        }
        catch (IOException e) {
            if (this.isInteractive) {
                this.logger.printError("Failed to create interactive terminal, fallback to non-interactive mode");
            }
            return this.nonInteractiveTerminal();
        }
    }

    private CypherShellTerminal nonInteractiveTerminal() {
        return new WriteOnlyCypherShellTerminal(this.out != null ? new PrintStream(this.out) : System.out);
    }

    public CypherShellTerminal buildJlineBasedTerminal() throws IOException {
        TerminalBuilder jLineTerminal = TerminalBuilder.builder();
        jLineTerminal.nativeSignals(true);
        if (this.in != null) {
            jLineTerminal.streams(this.in, this.out);
        }
        if (this.dumb) {
            Attributes attributes = new Attributes();
            attributes.setLocalFlag(Attributes.LocalFlag.ECHO, false);
            jLineTerminal.jna(false).jansi(false);
            jLineTerminal.dumb(true).type("dumb").attributes(attributes);
        }
        LineReader reader = LineReaderBuilder.builder().terminal(jLineTerminal.build()).parser((Parser)new CypherJlineParser(new ShellStatementParser())).completer((Completer)NullCompleter.INSTANCE).history((History)new DefaultHistory()).expander((Expander)new JlineTerminal.EmptyExpander()).option(LineReader.Option.DISABLE_EVENT_EXPANSION, true).option(LineReader.Option.DISABLE_HIGHLIGHTER, true).variable("disable-completion", (Object)true).build();
        return new JlineTerminal(reader, this.isInteractive, this.logger);
    }

    public static CypherShellTerminalBuilder terminalBuilder() {
        return new CypherShellTerminalBuilder();
    }
}

