/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.commands;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.neo4j.shell.ParameterMap;
import org.neo4j.shell.commands.Command;
import org.neo4j.shell.commands.CommandHelper;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.exception.ExitException;
import org.neo4j.shell.log.Logger;
import org.neo4j.shell.prettyprint.CypherVariablesFormatter;

public class Params
implements Command {
    public static final String COMMAND_NAME = ":params";
    private static final Pattern backtickPattern = Pattern.compile("^\\s*(?<key>(`([^`])*`)+?)\\s*");
    private final Logger logger;
    private final ParameterMap parameterMap;

    public Params(@Nonnull Logger logger, @Nonnull ParameterMap parameterMap) {
        this.logger = logger;
        this.parameterMap = parameterMap;
    }

    @Override
    @Nonnull
    public String getName() {
        return COMMAND_NAME;
    }

    @Override
    @Nonnull
    public String getDescription() {
        return "Print all currently set query parameters and their values";
    }

    @Override
    @Nonnull
    public String getUsage() {
        return "[parameter]";
    }

    @Override
    @Nonnull
    public String getHelp() {
        return "Print a table of all currently set query parameters or the value for the given parameter";
    }

    @Override
    @Nonnull
    public List<String> getAliases() {
        return Arrays.asList(":parameters");
    }

    @Override
    public void execute(@Nonnull String argString) throws ExitException, CommandException {
        String trim = argString.trim();
        Matcher matcher = backtickPattern.matcher(trim);
        if (trim.startsWith("`") && matcher.matches()) {
            this.listParam(trim);
        } else {
            String[] args = CommandHelper.simpleArgParse(argString, 0, 1, COMMAND_NAME, this.getUsage());
            if (args.length > 0) {
                this.listParam(args[0]);
            } else {
                this.listAllParams();
            }
        }
    }

    private void listParam(@Nonnull String name) throws CommandException {
        String parameterName = CypherVariablesFormatter.unescapedCypherVariable(name);
        if (!this.parameterMap.getAllAsUserInput().containsKey(parameterName)) {
            throw new CommandException("Unknown parameter: " + name);
        }
        this.listParam(name.length(), name, this.parameterMap.getAllAsUserInput().get(parameterName).getValueAsString());
    }

    private void listParam(int leftColWidth, @Nonnull String key, @Nonnull Object value) {
        this.logger.printOut(String.format(":param %-" + leftColWidth + "s => %s", key, value));
    }

    private void listAllParams() {
        List<String> keys = this.parameterMap.getAllAsUserInput().keySet().stream().sorted().collect(Collectors.toList());
        int leftColWidth = keys.stream().map(s -> CypherVariablesFormatter.escape(s).length()).reduce(0, Math::max);
        keys.forEach(key -> this.listParam(leftColWidth, CypherVariablesFormatter.escape(key), this.parameterMap.getAllAsUserInput().get(key).getValueAsString()));
    }
}

