/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.prettyprint;

import java.util.Set;
import javax.annotation.Nonnull;
import org.neo4j.shell.cli.Format;
import org.neo4j.shell.prettyprint.LinePrinter;
import org.neo4j.shell.prettyprint.OutputFormatter;
import org.neo4j.shell.prettyprint.PrettyConfig;
import org.neo4j.shell.prettyprint.SimpleOutputFormatter;
import org.neo4j.shell.prettyprint.StatisticsCollector;
import org.neo4j.shell.prettyprint.TableOutputFormatter;
import org.neo4j.shell.state.BoltResult;

public class PrettyPrinter {
    private final StatisticsCollector statisticsCollector;
    private final OutputFormatter outputFormatter;

    public PrettyPrinter(@Nonnull PrettyConfig prettyConfig) {
        this.statisticsCollector = new StatisticsCollector(prettyConfig.format);
        this.outputFormatter = this.selectFormatter(prettyConfig);
    }

    public void format(@Nonnull BoltResult result, LinePrinter linePrinter) {
        Set<OutputFormatter.Capabilities> capabilities = this.outputFormatter.capabilities();
        int numberOfRows = 0;
        if (capabilities.contains((Object)OutputFormatter.Capabilities.RESULT)) {
            numberOfRows = this.outputFormatter.formatAndCount(result, linePrinter);
        }
        if (capabilities.contains((Object)OutputFormatter.Capabilities.INFO)) {
            this.printIfNotEmpty(this.outputFormatter.formatInfo(result.getSummary()), linePrinter);
        }
        if (capabilities.contains((Object)OutputFormatter.Capabilities.PLAN)) {
            this.printIfNotEmpty(this.outputFormatter.formatPlan(result.getSummary()), linePrinter);
        }
        if (capabilities.contains((Object)OutputFormatter.Capabilities.FOOTER)) {
            this.printIfNotEmpty(this.outputFormatter.formatFooter(result, numberOfRows), linePrinter);
        }
        if (capabilities.contains((Object)OutputFormatter.Capabilities.STATISTICS)) {
            this.printIfNotEmpty(this.statisticsCollector.collect(result.getSummary()), linePrinter);
        }
    }

    String format(@Nonnull BoltResult result) {
        StringBuilder sb = new StringBuilder();
        this.format(result, line -> {
            if (line != null && !line.trim().isEmpty()) {
                sb.append(line).append(OutputFormatter.NEWLINE);
            }
        });
        return sb.toString();
    }

    private void printIfNotEmpty(String s, LinePrinter linePrinter) {
        if (!s.isEmpty()) {
            linePrinter.printOut(s);
        }
    }

    private OutputFormatter selectFormatter(PrettyConfig prettyConfig) {
        if (prettyConfig.format == Format.VERBOSE) {
            return new TableOutputFormatter(prettyConfig.wrap, prettyConfig.numSampleRows);
        }
        return new SimpleOutputFormatter();
    }
}

