/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jline.console.ConsoleReader;
import org.neo4j.driver.exceptions.AuthenticationException;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.shell.ConnectionConfig;
import org.neo4j.shell.CypherShell;
import org.neo4j.shell.ShellRunner;
import org.neo4j.shell.build.Build;
import org.neo4j.shell.cli.CliArgHelper;
import org.neo4j.shell.cli.CliArgs;
import org.neo4j.shell.commands.CommandHelper;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.exception.ThrowingAction;
import org.neo4j.shell.log.AnsiFormattedText;
import org.neo4j.shell.log.AnsiLogger;
import org.neo4j.shell.log.Logger;
import org.neo4j.shell.prettyprint.LinePrinter;
import org.neo4j.shell.prettyprint.PrettyConfig;
import org.neo4j.shell.util.Versions;

public class Main {
    public static final int EXIT_FAILURE = 1;
    public static final int EXIT_SUCCESS = 0;
    static final String NEO_CLIENT_ERROR_SECURITY_UNAUTHORIZED = "Neo.ClientError.Security.Unauthorized";
    private final InputStream in;
    private final PrintStream out;
    private final boolean hasSpecialInteractiveOutputStream;

    Main() {
        this(System.in, System.out, false);
    }

    Main(InputStream in, PrintStream out) {
        this(in, out, true);
    }

    private Main(InputStream in, PrintStream out, boolean hasSpecialInteractiveOutputStream) {
        this.in = in;
        this.out = out;
        this.hasSpecialInteractiveOutputStream = hasSpecialInteractiveOutputStream;
    }

    public static void main(String[] args) {
        CliArgs cliArgs = CliArgHelper.parse(args);
        if (cliArgs == null) {
            System.exit(1);
        }
        Main main = new Main();
        main.startShell(cliArgs);
    }

    private OutputStream getOutputStreamForInteractivePrompt() {
        return this.hasSpecialInteractiveOutputStream ? this.out : ShellRunner.getOutputStreamForInteractivePrompt();
    }

    void startShell(@Nonnull CliArgs cliArgs) {
        if (cliArgs.getVersion()) {
            this.out.println("Cypher-Shell " + Build.version());
        }
        if (cliArgs.getDriverVersion()) {
            this.out.println("Neo4j Driver " + Build.driverVersion());
        }
        if (cliArgs.getVersion() || cliArgs.getDriverVersion()) {
            return;
        }
        AnsiLogger logger = new AnsiLogger(cliArgs.getDebugMode());
        PrettyConfig prettyConfig = new PrettyConfig(cliArgs);
        CypherShell shell = new CypherShell((LinePrinter)logger, prettyConfig, ShellRunner.shouldBeInteractive(cliArgs), cliArgs.getParameters());
        int exitCode = this.runShell(cliArgs, shell, logger);
        System.exit(exitCode);
    }

    int runShell(@Nonnull CliArgs cliArgs, @Nonnull CypherShell shell, Logger logger) {
        ConnectionConfig connectionConfig = new ConnectionConfig(cliArgs.getScheme(), cliArgs.getHost(), cliArgs.getPort(), cliArgs.getUsername(), cliArgs.getPassword(), cliArgs.getEncryption(), cliArgs.getDatabase());
        try {
            if (cliArgs.getCypher().isPresent()) {
                this.connectMaybeInteractively(shell, connectionConfig, !cliArgs.getNonInteractive() && ShellRunner.isInputInteractive(), !cliArgs.getNonInteractive() && ShellRunner.isOutputInteractive(), !cliArgs.getNonInteractive(), () -> shell.execute(cliArgs.getCypher().get()));
                return 0;
            }
            ConnectionConfig newConnectionConfig = this.connectMaybeInteractively(shell, connectionConfig, !cliArgs.getNonInteractive() && ShellRunner.isInputInteractive(), !cliArgs.getNonInteractive() && ShellRunner.isOutputInteractive(), !cliArgs.getNonInteractive());
            if (!newConnectionConfig.driverUrl().equals(connectionConfig.driverUrl())) {
                String fallbackWarning = "Failed to connect to " + connectionConfig.driverUrl() + ", fallback to " + newConnectionConfig.driverUrl();
                logger.printIfVerbose(AnsiFormattedText.s().colorOrange().append(fallbackWarning).formattedString());
            }
            ShellRunner shellRunner = ShellRunner.getShellRunner(cliArgs, shell, logger, newConnectionConfig);
            CommandHelper commandHelper = new CommandHelper(logger, shellRunner.getHistorian(), shell);
            shell.setCommandHelper(commandHelper);
            return shellRunner.runUntilEnd();
        }
        catch (Throwable e) {
            logger.printError(e);
            return 1;
        }
    }

    ConnectionConfig connectMaybeInteractively(@Nonnull CypherShell shell, @Nonnull ConnectionConfig connectionConfig, boolean inputInteractive, boolean outputInteractive, boolean shouldPromptForPassword) throws Exception {
        return this.connectMaybeInteractively(shell, connectionConfig, inputInteractive, outputInteractive, shouldPromptForPassword, null);
    }

    private ConnectionConfig connectMaybeInteractively(@Nonnull CypherShell shell, @Nonnull ConnectionConfig connectionConfig, boolean inputInteractive, boolean outputInteractive, boolean shouldPromptForPassword, ThrowingAction<CommandException> command) throws Exception {
        boolean didPrompt = false;
        if (inputInteractive && !connectionConfig.username().isEmpty() && connectionConfig.password().isEmpty()) {
            this.promptForUsernameAndPassword(connectionConfig, outputInteractive);
            didPrompt = true;
        }
        while (true) {
            try {
                return shell.connect(connectionConfig, command);
            }
            catch (AuthenticationException e) {
                if (didPrompt || !inputInteractive || !connectionConfig.username().isEmpty() && !connectionConfig.password().isEmpty()) {
                    throw e;
                }
                this.promptForUsernameAndPassword(connectionConfig, outputInteractive);
                didPrompt = true;
                continue;
            }
            catch (Neo4jException e) {
                if (shouldPromptForPassword && Versions.isPasswordChangeRequiredException(e)) {
                    this.promptForPasswordChange(connectionConfig, outputInteractive);
                    shell.changePassword(connectionConfig);
                    didPrompt = true;
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    private void promptForUsernameAndPassword(ConnectionConfig connectionConfig, boolean outputInteractive) throws Exception {
        OutputStream promptOutputStream = this.getOutputStreamForInteractivePrompt();
        try (ConsoleReader consoleReader = new ConsoleReader(this.in, promptOutputStream);){
            consoleReader.setExpandEvents(false);
            consoleReader.setHandleUserInterrupt(false);
            if (connectionConfig.username().isEmpty()) {
                String username = outputInteractive ? this.promptForNonEmptyText("username", consoleReader, null) : this.promptForText("username", consoleReader, null);
                connectionConfig.setUsername(username);
            }
            if (connectionConfig.password().isEmpty()) {
                connectionConfig.setPassword(this.promptForText("password", consoleReader, Character.valueOf('*')));
            }
        }
    }

    private void promptForPasswordChange(ConnectionConfig connectionConfig, boolean outputInteractive) throws Exception {
        OutputStream promptOutputStream = this.getOutputStreamForInteractivePrompt();
        try (ConsoleReader consoleReader = new ConsoleReader(this.in, promptOutputStream);){
            consoleReader.setExpandEvents(false);
            consoleReader.setHandleUserInterrupt(false);
            consoleReader.println((CharSequence)"Password change required");
            if (connectionConfig.username().isEmpty()) {
                String username = outputInteractive ? this.promptForNonEmptyText("username", consoleReader, null) : this.promptForText("username", consoleReader, null);
                connectionConfig.setUsername(username);
            }
            if (connectionConfig.password().isEmpty()) {
                connectionConfig.setPassword(this.promptForText("password", consoleReader, Character.valueOf('*')));
            }
            String newPassword = outputInteractive ? this.promptForNonEmptyText("new password", consoleReader, Character.valueOf('*')) : this.promptForText("new password", consoleReader, Character.valueOf('*'));
            connectionConfig.setNewPassword(newPassword);
        }
    }

    @Nonnull
    private String promptForNonEmptyText(@Nonnull String prompt, @Nonnull ConsoleReader consoleReader, @Nullable Character mask) throws Exception {
        String text = this.promptForText(prompt, consoleReader, mask);
        if (!text.isEmpty()) {
            return text;
        }
        consoleReader.println((CharSequence)(prompt + " cannot be empty"));
        consoleReader.println();
        return this.promptForNonEmptyText(prompt, consoleReader, mask);
    }

    @Nonnull
    private String promptForText(@Nonnull String prompt, @Nonnull ConsoleReader consoleReader, @Nullable Character mask) throws Exception {
        String line = consoleReader.readLine(prompt + ": ", mask);
        if (line == null) {
            throw new CommandException("No text could be read, exiting...");
        }
        return line;
    }
}

