/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.annotations.api;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.neo4j.annotations.api.IgnoreApiCheck;
import org.neo4j.annotations.api.PublicApi;

public class PublicApiAnnotationProcessor
extends AbstractProcessor {
    static final String VERIFY_TOGGLE = "enablePublicApiSignatureCheck";
    private final Set<String> publicElements = new TreeSet<String>();
    private final Set<String> validatedDeclaredTypes = new HashSet<String>();
    private final List<String> scope = new ArrayList<String>();
    static final String GENERATED_SIGNATURE_DESTINATION = "META-INF/PublicApi.txt";
    private final boolean testExecution;
    private final String newLine;
    private boolean inDeprecatedScope;
    private Types typeUtils;

    public PublicApiAnnotationProcessor() {
        this(false);
    }

    PublicApiAnnotationProcessor(boolean forTest) {
        this(forTest, "\n");
    }

    PublicApiAnnotationProcessor(boolean forTest, String newLine) {
        this.testExecution = forTest;
        this.newLine = newLine;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.typeUtils = processingEnv.getTypeUtils();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(PublicApi.class.getName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            if (roundEnv.processingOver()) {
                if (!roundEnv.errorRaised()) {
                    this.generateSignature();
                }
            } else {
                this.process(roundEnv);
            }
        }
        catch (Exception e) {
            this.error("Public API annotation processor failed: " + ExceptionUtils.getStackTrace((Throwable)e));
        }
        return false;
    }

    private void generateSignature() throws IOException {
        if (!Boolean.getBoolean(VERIFY_TOGGLE)) {
            return;
        }
        if (!this.publicElements.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String element : this.publicElements) {
                sb.append(element).append(this.newLine);
            }
            String newSignature = sb.toString();
            FileObject file = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", GENERATED_SIGNATURE_DESTINATION, new Element[0]);
            try (BufferedWriter writer = new BufferedWriter(file.openWriter());){
                writer.write(newSignature);
            }
            if (!this.testExecution) {
                Path path = Path.of(file.toUri());
                Path metaPath = PublicApiAnnotationProcessor.getAndAssertParent(path, "META-INF");
                Path classesPath = PublicApiAnnotationProcessor.getAndAssertParent(metaPath, "classes");
                Path targetPath = PublicApiAnnotationProcessor.getAndAssertParent(classesPath, "target");
                Path mavenModulePath = Objects.requireNonNull(targetPath.getParent());
                Path oldSignaturePath = mavenModulePath.resolve("PublicApi.txt");
                if (Boolean.getBoolean("overwrite")) {
                    this.info("Overwriting " + oldSignaturePath);
                    Files.writeString(oldSignaturePath, (CharSequence)newSignature, StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                }
                if (!Files.exists(oldSignaturePath, new LinkOption[0])) {
                    this.error(String.format("Missing file %s, use `-Doverwrite` to create it.", oldSignaturePath));
                    return;
                }
                String oldSignature = Files.readString(oldSignaturePath, StandardCharsets.UTF_8);
                if (!oldSignature.equals(newSignature)) {
                    if (!(oldSignature = oldSignature.replace("\r\n", "\n")).equals(newSignature = newSignature.replace("\r\n", "\n"))) {
                        StringBuilder diff = this.diff(oldSignaturePath);
                        this.error(String.format("Public API signature mismatch. The generated signature, %s, does not match the old signature in %s.%nSpecify `-Doverwrite` to maven to replace it. Changed public elements, compared to the committed PublicApi.txt:%n%s%n", path, oldSignaturePath, diff));
                    }
                } else {
                    this.info("Public API signature matches. " + oldSignaturePath);
                }
            }
        }
    }

    private StringBuilder diff(Path oldSignaturePath) throws IOException {
        HashSet<String> oldLines = new HashSet<String>();
        try (Stream<String> lines = Files.lines(oldSignaturePath, StandardCharsets.UTF_8);){
            lines.forEach(oldLines::add);
        }
        StringBuilder diff = new StringBuilder();
        PublicApiAnnotationProcessor.diffSide(diff, oldLines, this.publicElements, '-');
        PublicApiAnnotationProcessor.diffSide(diff, this.publicElements, oldLines, '+');
        return diff;
    }

    private static void diffSide(StringBuilder diff, Set<String> left, Set<String> right, char diffSign) {
        for (String oldPublicElement : left) {
            if (right.contains(oldPublicElement)) continue;
            diff.append(diffSign).append(oldPublicElement).append(String.format("%n", new Object[0]));
        }
    }

    private static Path getAndAssertParent(Path path, String name) {
        Path parent = path.getParent();
        if (!parent.getFileName().toString().equals(name)) {
            throw new IllegalStateException(path.toAbsolutePath() + " parent is not " + name);
        }
        return parent;
    }

    private void process(RoundEnvironment roundEnv) {
        Set elements = roundEnv.getElementsAnnotatedWith(PublicApi.class).stream().map(TypeElement.class::cast).collect(Collectors.toSet());
        for (TypeElement publicClass : elements) {
            this.pushScope(publicClass.getQualifiedName().toString());
            this.processType(publicClass);
            this.popScope();
        }
    }

    private void processType(TypeElement typeElement) {
        if (!typeElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
            this.error("Class marked as public is not actually public", typeElement);
        }
        StringBuilder sb = new StringBuilder();
        this.addTypeName(sb, typeElement);
        PublicApiAnnotationProcessor.addModifiers(sb, typeElement);
        this.addKindIdentifier(sb, typeElement);
        this.addSuperClass(sb, typeElement);
        this.addInterfaces(sb, typeElement);
        this.publicElements.add(sb.toString());
        for (Element element : typeElement.getEnclosedElements()) {
            Set<Modifier> modifiers = element.getModifiers();
            if (!modifiers.contains((Object)Modifier.PUBLIC) && !modifiers.contains((Object)Modifier.PROTECTED)) continue;
            ElementKind kind = element.getKind();
            switch (kind) {
                case ENUM: 
                case INTERFACE: 
                case CLASS: {
                    this.pushScope("." + element.getSimpleName());
                    this.processType((TypeElement)element);
                    break;
                }
                case ENUM_CONSTANT: 
                case FIELD: {
                    this.pushScope("#" + element);
                    this.processField((VariableElement)element);
                    break;
                }
                case CONSTRUCTOR: 
                case METHOD: {
                    this.pushScope("::" + element);
                    this.processMethod((ExecutableElement)element);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("???: " + kind));
                }
            }
            this.popScope();
        }
    }

    private void processField(VariableElement variableElement) {
        StringBuilder sb = new StringBuilder();
        this.addFieldName(sb, variableElement);
        this.addReturn(sb, variableElement.asType());
        PublicApiAnnotationProcessor.addModifiers(sb, variableElement);
        PublicApiAnnotationProcessor.addConstantValue(sb, variableElement);
        this.publicElements.add(sb.toString());
    }

    private void processMethod(ExecutableElement element) {
        if (element.getAnnotation(Deprecated.class) != null) {
            this.inDeprecatedScope = true;
        }
        StringBuilder sb = new StringBuilder();
        this.addMethodName(sb, element);
        this.addParameters(sb, element);
        this.addReturn(sb, element.getReturnType());
        PublicApiAnnotationProcessor.addModifiers(sb, element);
        this.addExceptions(sb, element);
        this.publicElements.add(sb.toString());
        this.inDeprecatedScope = false;
    }

    private void addInterfaces(StringBuilder sb, TypeElement typeElement) {
        List<? extends TypeMirror> interfaces = typeElement.getInterfaces();
        if (!interfaces.isEmpty()) {
            sb.append(interfaces.stream().map(this::encodeType).collect(Collectors.joining(", ", " implements ", "")));
        }
    }

    private void addSuperClass(StringBuilder sb, TypeElement typeElement) {
        if (typeElement.getKind() != ElementKind.INTERFACE && typeElement.getKind() != ElementKind.ANNOTATION_TYPE) {
            sb.append(" extends ");
            sb.append(this.encodeType(typeElement.getSuperclass()));
        }
    }

    private void addKindIdentifier(StringBuilder sb, TypeElement typeElement) {
        ElementKind kind = typeElement.getKind();
        switch (kind) {
            case CLASS: {
                sb.append(" class");
                break;
            }
            case INTERFACE: {
                sb.append(" interface");
                break;
            }
            case ENUM: {
                sb.append(" enum");
                break;
            }
            case ANNOTATION_TYPE: {
                sb.append(" annotation");
                break;
            }
            default: {
                this.error("Unhandled ElementKind: " + kind);
            }
        }
    }

    private void addTypeName(StringBuilder sb, TypeElement typeElement) {
        sb.append(typeElement.getQualifiedName());
        this.addTypeParameter(sb, typeElement.getTypeParameters());
    }

    private void addTypeParameter(StringBuilder sb, Collection<? extends TypeParameterElement> typeParameters) {
        if (!typeParameters.isEmpty()) {
            sb.append(typeParameters.stream().map(this::getGetBounds).collect(Collectors.joining(", ", "<", ">")));
        }
    }

    private String getGetBounds(TypeParameterElement typeParameter) {
        List bounds = typeParameter.getBounds().stream().map(this::encodeType).collect(Collectors.toList());
        if (bounds.isEmpty()) {
            return typeParameter.toString();
        }
        return typeParameter + " extends " + String.join((CharSequence)" & ", bounds);
    }

    private void addFieldName(StringBuilder sb, VariableElement variableElement) {
        sb.append(this.encodeType(variableElement.getEnclosingElement().asType()));
        sb.append("::");
        sb.append(variableElement.getSimpleName());
    }

    private void addParameters(StringBuilder sb, ExecutableElement element) {
        sb.append('(');
        List<? extends VariableElement> parameters = element.getParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            VariableElement parameter = parameters.get(i);
            sb.append(this.encodeType(parameter.asType()));
            if (i != parameters.size() - 1) {
                sb.append(", ");
                continue;
            }
            if (!element.isVarArgs()) continue;
            if (parameter.asType().getKind() == TypeKind.ARRAY) {
                sb.setLength(sb.length() - 2);
            }
            sb.append("...");
        }
        sb.append(')');
    }

    private void addReturn(StringBuilder sb, TypeMirror type) {
        sb.append(' ');
        sb.append(this.encodeType(type));
    }

    private void addMethodName(StringBuilder sb, ExecutableElement element) {
        sb.append(this.encodeType(element.getEnclosingElement().asType()));
        sb.append("::");
        this.addTypeParameter(sb, element.getTypeParameters());
        if (element.getKind() == ElementKind.CONSTRUCTOR) {
            sb.append(element.getEnclosingElement().getSimpleName());
        } else {
            sb.append(element.getSimpleName());
        }
    }

    private static void addModifiers(StringBuilder sb, Element element) {
        for (Modifier modifier : element.getModifiers()) {
            sb.append(' ');
            sb.append((Object)modifier);
        }
    }

    private void addExceptions(StringBuilder sb, ExecutableElement element) {
        List<? extends TypeMirror> exceptions = element.getThrownTypes();
        if (!exceptions.isEmpty()) {
            sb.append(exceptions.stream().map(this::encodeType).collect(Collectors.joining(", ", " throws ", "")));
        }
    }

    private static void addConstantValue(StringBuilder sb, VariableElement variableElement) {
        Object constantValue = variableElement.getConstantValue();
        if (constantValue != null) {
            sb.append(" = ");
            sb.append(constantValue);
        }
    }

    private String encodeType(TypeMirror type) {
        TypeKind kind = type.getKind();
        if (kind.isPrimitive()) {
            return kind.toString().toLowerCase(Locale.ROOT);
        }
        if (kind == TypeKind.ARRAY) {
            ArrayType arrayType = (ArrayType)type;
            return this.encodeType(arrayType.getComponentType()) + "[]";
        }
        if (kind == TypeKind.TYPEVAR) {
            TypeVariable typeVariable = (TypeVariable)type;
            return "#" + typeVariable;
        }
        if (kind == TypeKind.DECLARED) {
            DeclaredType referenceType = (DeclaredType)type;
            this.validatePublicVisibility(referenceType);
            return referenceType.toString();
        }
        if (kind == TypeKind.VOID) {
            return "void";
        }
        this.error("Unhandled type: " + kind);
        return "ERROR";
    }

    private void validatePublicVisibility(DeclaredType declaredType) {
        String declaredTypeName = declaredType.toString();
        if (!this.validatedDeclaredTypes.add(declaredTypeName)) {
            return;
        }
        TypeElement element = (TypeElement)this.typeUtils.asElement(declaredType);
        if (!element.getModifiers().contains((Object)Modifier.PUBLIC)) {
            this.error("Element that is exposed through the API is not visible", element);
        }
        for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
            if (typeMirror.getKind() == TypeKind.WILDCARD) {
                this.validateWildcard((WildcardType)typeMirror);
            }
            if (typeMirror.getKind() != TypeKind.DECLARED) continue;
            this.validatePublicVisibility((DeclaredType)typeMirror);
        }
        if (!declaredTypeName.startsWith("org.neo4j.") && !declaredTypeName.startsWith("com.neo4j.")) {
            return;
        }
        if (element.getNestingKind().isNested()) {
            TypeElement parent;
            while ((parent = (TypeElement)element.getEnclosingElement()).getNestingKind().isNested()) {
            }
            this.assertAnnotated(element, parent, element.getQualifiedName() + "'s parent, " + parent.getQualifiedName() + ",");
        } else {
            this.assertAnnotated(element, element, element.getQualifiedName() + " exposed through the API");
        }
    }

    private void validateWildcard(WildcardType wildcardType) {
        this.filterWildcard(wildcardType.getExtendsBound());
        this.filterWildcard(wildcardType.getSuperBound());
    }

    private void filterWildcard(TypeMirror extendsBound) {
        if (extendsBound != null) {
            TypeKind kind = extendsBound.getKind();
            if (kind == TypeKind.DECLARED) {
                this.validatePublicVisibility((DeclaredType)extendsBound);
            }
            if (kind == TypeKind.WILDCARD) {
                this.validateWildcard((WildcardType)extendsBound);
            }
        }
    }

    private void assertAnnotated(TypeElement element, TypeElement parent, String msg) {
        if (parent.getAnnotation(IgnoreApiCheck.class) != null) {
            return;
        }
        if (parent.getAnnotation(PublicApi.class) == null) {
            if (this.inDeprecatedScope) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Non-public element, " + element + ", is exposed through the API via a deprecated method", element);
            } else {
                this.error(msg + " is not marked with @" + PublicApi.class.getSimpleName(), element);
            }
        }
    }

    private void pushScope(String e) {
        this.scope.add(e);
    }

    private void popScope() {
        this.scope.remove(this.scope.size() - 1);
    }

    private void info(String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, msg);
    }

    private void error(String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
    }

    private void error(String msg, Element element) {
        StringBuilder sb = new StringBuilder();
        sb.append("Error processing ");
        this.scope.forEach(sb::append);
        sb.append(':');
        sb.append(System.lineSeparator());
        sb.append(msg);
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, sb.toString(), element);
    }
}

