/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.compression.impl;

import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.Pointer;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.executioner.GridExecutioner;
import org.nd4j.linalg.compression.CompressedDataBuffer;
import org.nd4j.linalg.compression.NDArrayCompressor;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCompressor
implements NDArrayCompressor {
    protected static Logger logger = LoggerFactory.getLogger(AbstractCompressor.class);

    public INDArray compress(INDArray array) {
        INDArray dup = array.dup(array.ordering());
        if (Nd4j.getExecutioner() instanceof GridExecutioner) {
            ((GridExecutioner)Nd4j.getExecutioner()).flushQueueBlocking();
        }
        dup.setData(this.compress(dup.data()));
        dup.markAsCompressed(true);
        return dup;
    }

    public void compressi(INDArray array) {
        if (array.isView()) {
            throw new UnsupportedOperationException("Impossible to apply inplace compression on View");
        }
        array.setData(this.compress(array.data()));
        array.markAsCompressed(true);
    }

    public void decompressi(INDArray array) {
        if (!array.isCompressed()) {
            return;
        }
        array.markAsCompressed(false);
        array.setData(this.decompress(array.data()));
    }

    public INDArray decompress(INDArray array) {
        DataBuffer buffer = this.decompress(array.data());
        DataBuffer shapeInfo = array.shapeInfoDataBuffer();
        INDArray rest = Nd4j.createArrayFromShapeBuffer((DataBuffer)buffer, (DataBuffer)shapeInfo);
        return rest;
    }

    public abstract DataBuffer decompress(DataBuffer var1);

    public abstract DataBuffer compress(DataBuffer var1);

    protected DataBuffer.TypeEx convertType(DataBuffer.Type type) {
        if (type == DataBuffer.Type.HALF) {
            return DataBuffer.TypeEx.FLOAT16;
        }
        if (type == DataBuffer.Type.FLOAT) {
            return DataBuffer.TypeEx.FLOAT;
        }
        if (type == DataBuffer.Type.DOUBLE) {
            return DataBuffer.TypeEx.DOUBLE;
        }
        throw new IllegalStateException("Unknown dataType: [" + type + "]");
    }

    protected DataBuffer.TypeEx getGlobalTypeEx() {
        DataBuffer.Type type = Nd4j.dataType();
        return this.convertType(type);
    }

    protected DataBuffer.TypeEx getBufferTypeEx(DataBuffer buffer) {
        DataBuffer.Type type = buffer.dataType();
        return this.convertType(type);
    }

    public INDArray compress(float[] data) {
        return this.compress(data, new int[]{1, data.length}, Nd4j.order().charValue());
    }

    public INDArray compress(double[] data) {
        return this.compress(data, new int[]{1, data.length}, Nd4j.order().charValue());
    }

    public INDArray compress(float[] data, int[] shape, char order) {
        FloatPointer pointer = new FloatPointer(data);
        DataBuffer shapeInfo = Nd4j.getShapeInfoProvider().createShapeInformation(shape, order);
        CompressedDataBuffer buffer = this.compressPointer(DataBuffer.TypeEx.FLOAT, (Pointer)pointer, data.length, 4);
        return Nd4j.createArrayFromShapeBuffer((DataBuffer)buffer, (DataBuffer)shapeInfo);
    }

    public INDArray compress(double[] data, int[] shape, char order) {
        DoublePointer pointer = new DoublePointer(data);
        DataBuffer shapeInfo = Nd4j.getShapeInfoProvider().createShapeInformation(shape, order);
        CompressedDataBuffer buffer = this.compressPointer(DataBuffer.TypeEx.DOUBLE, (Pointer)pointer, data.length, 8);
        return Nd4j.createArrayFromShapeBuffer((DataBuffer)buffer, (DataBuffer)shapeInfo);
    }

    protected abstract CompressedDataBuffer compressPointer(DataBuffer.TypeEx var1, Pointer var2, int var3, int var4);
}

