/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.nativeblas;

import java.util.Properties;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;
import org.bytedeco.javacpp.annotation.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Platform(include={"NativeOps.h"}, compiler={"cpp11"}, link={"nd4j"}, library="jnind4j")
public class NativeOps
extends Pointer {
    private static Logger log = LoggerFactory.getLogger(NativeOps.class);

    public NativeOps() {
        this.allocate();
        this.initializeDevicesAndFunctions();
        String numThreadsString = System.getenv("OMP_NUM_THREADS");
        if (numThreadsString != null && !numThreadsString.isEmpty()) {
            int numThreads = Integer.parseInt(numThreadsString);
            this.setOmpNumThreads(numThreads);
        } else {
            this.setOmpNumThreads(Runtime.getRuntime().availableProcessors());
        }
        log.debug("Number of threads used for linear algebra " + this.ompGetMaxThreads());
    }

    private native void allocate();

    public native double execIndexReduceScalarDouble(PointerPointer var1, int var2, Pointer var3, Pointer var4, Pointer var5);

    public native void execIndexReduceDouble(PointerPointer var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, int var9);

    public native void execBroadcastDouble(PointerPointer var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, int var10);

    public native void execPairwiseTransformDouble(PointerPointer var1, int var2, Pointer var3, int var4, Pointer var5, int var6, Pointer var7, int var8, Pointer var9, long var10);

    public native void execPairwiseTransformDouble(PointerPointer var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12);

    public native void execPairwiseTransformDouble(PointerPointer var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9);

    public native void execReduceDouble(PointerPointer var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7);

    public native void execReduceDouble(PointerPointer var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, int var9);

    public native double execReduceScalarDouble(PointerPointer var1, int var2, Pointer var3, Pointer var4, Pointer var5);

    public native void execReduce3Double(PointerPointer var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9);

    public native double execReduce3ScalarDouble(PointerPointer var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7);

    public native void execReduce3Double(PointerPointer var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, Pointer var10, int var11);

    public native void execScalarDouble(PointerPointer var1, int var2, Pointer var3, int var4, Pointer var5, int var6, double var7, Pointer var9, long var10);

    public native void execScalarDouble(PointerPointer var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, double var7, Pointer var9);

    public native void execScalarDouble(PointerPointer var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, double var7, Pointer var9, long var10, Pointer var12, Pointer var13);

    public native double execSummaryStatsScalarDouble(PointerPointer var1, int var2, Pointer var3, Pointer var4, Pointer var5, boolean var6);

    public native void execSummaryStatsDouble(PointerPointer var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, boolean var8);

    public native void execSummaryStatsDouble(PointerPointer var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, int var9, boolean var10);

    public native void execTransformDouble(PointerPointer var1, int var2, Pointer var3, int var4, Pointer var5, int var6, Pointer var7, long var8);

    public native void execTransformDouble(PointerPointer var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7);

    public native void execTransformDouble(PointerPointer var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9);

    public native float execIndexReduceScalarFloat(PointerPointer var1, int var2, Pointer var3, Pointer var4, Pointer var5);

    public native void execIndexReduceFloat(PointerPointer var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, int var9);

    public native void execBroadcastFloat(PointerPointer var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, int var10);

    public native void execPairwiseTransformFloat(PointerPointer var1, int var2, Pointer var3, int var4, Pointer var5, int var6, Pointer var7, int var8, Pointer var9, long var10);

    public native void execPairwiseTransformFloat(PointerPointer var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12);

    public native void execPairwiseTransformFloat(PointerPointer var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9);

    public native void execReduceFloat(PointerPointer var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7);

    public native void execReduceFloat(PointerPointer var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, int var9);

    public native float execReduceScalarFloat(PointerPointer var1, int var2, Pointer var3, Pointer var4, Pointer var5);

    public native void execReduce3Float(PointerPointer var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9);

    public native float execReduce3ScalarFloat(PointerPointer var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7);

    public native void execReduce3Float(PointerPointer var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, Pointer var10, int var11);

    public native void execScalarFloat(PointerPointer var1, int var2, Pointer var3, int var4, Pointer var5, int var6, double var7, Pointer var9, long var10);

    public native void execScalarFloat(PointerPointer var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, float var7, Pointer var8);

    public native void execScalarFloat(PointerPointer var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, double var7, Pointer var9, Pointer var10, Pointer var11);

    public native float execSummaryStatsScalarFloat(PointerPointer var1, int var2, Pointer var3, Pointer var4, Pointer var5, boolean var6);

    public native void execSummaryStatsFloat(PointerPointer var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, boolean var8);

    public native void execSummaryStatsFloat(PointerPointer var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, int var9, boolean var10);

    public native void execTransformFloat(PointerPointer var1, int var2, Pointer var3, int var4, Pointer var5, int var6, Pointer var7, long var8);

    public native void execTransformFloat(PointerPointer var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7);

    public native void execTransformFloat(PointerPointer var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9);

    public native void flattenFloat(PointerPointer var1, int var2, char var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7);

    public native void flattenDouble(PointerPointer var1, int var2, char var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7);

    public native void concatDouble(PointerPointer var1, int var2, int var3, PointerPointer var4, PointerPointer var5, Pointer var6, Pointer var7, PointerPointer var8, PointerPointer var9);

    public native void concatFloat(PointerPointer var1, int var2, int var3, PointerPointer var4, PointerPointer var5, Pointer var6, Pointer var7, PointerPointer var8, PointerPointer var9);

    public native int ompGetMaxThreads();

    public native int ompGetNumThreads();

    public native void setOmpNumThreads(int var1);

    public native void initializeDevicesAndFunctions();

    public synchronized native Pointer mallocHost(long var1, int var3);

    public synchronized native Pointer mallocDevice(long var1, Pointer var3, int var4);

    public native int freeHost(Pointer var1);

    public native int freeDevice(Pointer var1, Pointer var2);

    public native Pointer createContext();

    public native Pointer createStream();

    public native Pointer createEvent();

    public native Pointer createBlasHandle();

    public native int registerEvent(Pointer var1, Pointer var2);

    public native int destroyEvent(Pointer var1);

    public native int setBlasStream(Pointer var1, Pointer var2);

    public native int setDevice(Pointer var1);

    public native int streamSynchronize(Pointer var1);

    public native int eventSynchronize(Pointer var1);

    public native long getDeviceFreeMemory(Pointer var1);

    public native long getDeviceTotalMemory(Pointer var1);

    public native int memcpy(Pointer var1, Pointer var2, long var3, int var5, Pointer var6);

    public native int memcpyAsync(Pointer var1, Pointer var2, long var3, int var5, Pointer var6);

    public native int memcpyConstantAsync(long var1, Pointer var3, long var4, int var6, Pointer var7);

    public native int memset(Pointer var1, int var2, long var3, int var5, Pointer var6);

    public native int memsetAsync(Pointer var1, int var2, long var3, int var5, Pointer var6);

    public native Pointer getConstantSpace();

    public native int getAvailableDevices();

    public native void enableDebugMode(boolean var1);

    public native void enableVerboseMode(boolean var1);

    public native void setGridLimit(int var1);

    public native void tadOnlyShapeInfo(Pointer var1, Pointer var2, int var3, Pointer var4, Pointer var5);

    public native void pullRowsFloat(PointerPointer var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6, Pointer var7, Pointer var8, Pointer var9);

    public native void pullRowsDouble(PointerPointer var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6, Pointer var7, Pointer var8, Pointer var9);

    static {
        String platform = Loader.getPlatform();
        Properties properties = Loader.loadProperties((String)(platform + "-nd4j"), (String)platform);
        properties.remove("platform.preloadpath");
        String s = System.getProperty("org.nd4j.nativeblas.pathsfirst", "false").toLowerCase();
        boolean pathsFirst = s.equals("true") || s.equals("t") || s.equals("");
        Loader.load(NativeOps.class, (Properties)properties, (boolean)pathsFirst);
    }
}

