/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.fft;

import com.google.common.base.Function;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.ops.transforms.Transforms;
import org.nd4j.linalg.util.ComplexNDArrayUtil;

public class VectorFFT
implements Function<IComplexNDArray, IComplexNDArray> {
    private int n;
    private int originalN = -1;

    public VectorFFT(int n) {
        this.n = n;
    }

    public IComplexNDArray apply(IComplexNDArray ndArray) {
        double len = this.n;
        int desiredElementsAlongDimension = ndArray.length();
        if (len > (double)desiredElementsAlongDimension) {
            ndArray = ComplexNDArrayUtil.padWithZeros(ndArray, new int[]{this.n});
        } else if (len < (double)desiredElementsAlongDimension) {
            ndArray = ComplexNDArrayUtil.truncate(ndArray, this.n, 0);
        }
        IComplexNumber c2 = Nd4j.createDouble(0.0, -2.0).muli(Math.PI);
        INDArray n = Nd4j.arange(0.0, this.n).reshape(1, this.n);
        INDArray k = n.reshape(new int[]{n.length(), 1});
        INDArray kTimesN = k.mmul(n);
        IComplexNDArray c1 = kTimesN.muli(c2);
        c1.divi(len);
        IComplexNDArray M = Transforms.exp(c1);
        IComplexNDArray reshaped = ndArray.reshape(new int[]{ndArray.length()});
        IComplexNDArray matrix = reshaped.mmul(M);
        if (this.originalN > 0) {
            matrix = ComplexNDArrayUtil.truncate(matrix, this.originalN, 0);
        }
        return matrix;
    }
}

