/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.fft;

import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.fft.FFTSliceOp;
import org.nd4j.linalg.fft.IFFTSliceOp;
import org.nd4j.linalg.fft.VectorFFT;
import org.nd4j.linalg.fft.VectorIFFT;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.linalg.util.ComplexNDArrayUtil;

public class FFT {
    public static IComplexNDArray fft(INDArray transform, int numElements) {
        IComplexNDArray inputC = Nd4j.createComplex(transform);
        if (inputC.isVector()) {
            return new VectorFFT(inputC.length()).apply(inputC);
        }
        return FFT.rawfft(inputC, numElements, inputC.shape().length - 1);
    }

    public static IComplexNDArray fft(IComplexNDArray inputC) {
        if (inputC.isVector()) {
            return new VectorFFT(inputC.length()).apply(inputC);
        }
        return FFT.rawfft(inputC, inputC.size(inputC.shape().length - 1), inputC.shape().length - 1);
    }

    public static IComplexNDArray fft(INDArray input) {
        IComplexNDArray inputC = Nd4j.createComplex(input);
        return FFT.fft(inputC);
    }

    public static IComplexNDArray fft(INDArray transform, int numElements, int dimension) {
        IComplexNDArray inputC = Nd4j.createComplex(transform);
        if (inputC.isVector()) {
            return new VectorFFT(numElements).apply(inputC);
        }
        return FFT.rawfft(inputC, numElements, dimension);
    }

    public static IComplexNDArray fft(IComplexNDArray inputC, int numElements) {
        return FFT.fft(inputC, numElements, inputC.shape().length - 1);
    }

    public static IComplexNDArray fft(IComplexNDArray inputC, int numElements, int dimension) {
        if (inputC.isVector()) {
            return new VectorFFT(numElements).apply(inputC);
        }
        return FFT.rawfft(inputC, numElements, dimension);
    }

    public static IComplexNDArray ifft(INDArray transform, int numElements, int dimension) {
        IComplexNDArray inputC = Nd4j.createComplex(transform);
        if (inputC.isVector()) {
            return new VectorIFFT(numElements).apply(inputC);
        }
        return FFT.rawifft(inputC, numElements, dimension);
    }

    public static IComplexNDArray ifft(IComplexNDArray inputC) {
        if (inputC.isVector()) {
            return new VectorIFFT(inputC.length()).apply(inputC);
        }
        return FFT.rawifft(inputC, inputC.size(inputC.shape().length - 1), inputC.shape().length - 1);
    }

    public static IComplexNDArray ifft(INDArray transform, int numElements) {
        IComplexNDArray inputC = Nd4j.createComplex(transform);
        if (inputC.isVector()) {
            return new VectorIFFT(numElements).apply(inputC);
        }
        return FFT.rawifft(inputC, numElements, inputC.shape().length - 1);
    }

    public static IComplexNDArray ifft(IComplexNDArray inputC, int numElements, int dimension) {
        if (inputC.isVector()) {
            return new VectorIFFT(numElements).apply(inputC);
        }
        return FFT.rawifft(inputC, numElements, dimension);
    }

    public static IComplexNDArray ifftn(INDArray transform, int dimension, int numElements) {
        return FFT.ifftn(Nd4j.createComplex(transform), dimension, numElements);
    }

    public static IComplexNDArray irfftn(IComplexNDArray arr) {
        int[] shape = arr.shape();
        IComplexNDArray ret = arr.dup();
        for (int i = 0; i < shape.length - 1; ++i) {
            ret = FFT.ifftn(ret, i, shape[i]);
        }
        return FFT.irfft(ret, 0);
    }

    public static IComplexNDArray irfft(IComplexNDArray arr, int dimension) {
        return FFT.fftn(arr, arr.size(dimension), dimension);
    }

    public static IComplexNDArray irfft(IComplexNDArray arr) {
        return arr;
    }

    public static IComplexNDArray ifftn(IComplexNDArray transform, int dimension, int numElements) {
        if (numElements < 1) {
            throw new IllegalArgumentException("No elements specified");
        }
        int[] finalShape = ArrayUtil.replace(transform.shape(), dimension, numElements);
        int[] axes = ArrayUtil.range(0, finalShape.length);
        IComplexNDArray result = transform.dup();
        int desiredElementsAlongDimension = result.size(dimension);
        if (numElements > desiredElementsAlongDimension) {
            result = ComplexNDArrayUtil.padWithZeros(result, finalShape);
        } else if (numElements < desiredElementsAlongDimension) {
            result = ComplexNDArrayUtil.truncate(result, numElements, dimension);
        }
        return FFT.rawifftn(result, finalShape, axes);
    }

    public static IComplexNDArray fftn(IComplexNDArray transform, int dimension, int numElements) {
        if (numElements < 1) {
            throw new IllegalArgumentException("No elements specified");
        }
        int[] finalShape = ArrayUtil.replace(transform.shape(), dimension, numElements);
        int[] axes = ArrayUtil.range(0, finalShape.length);
        IComplexNDArray result = transform.dup();
        int desiredElementsAlongDimension = result.size(dimension);
        if (numElements > desiredElementsAlongDimension) {
            result = ComplexNDArrayUtil.padWithZeros(result, finalShape);
        } else if (numElements < desiredElementsAlongDimension) {
            result = ComplexNDArrayUtil.truncate(result, numElements, dimension);
        }
        return FFT.rawfftn(result, finalShape, axes);
    }

    public static IComplexNDArray fftn(INDArray transform, int dimension, int numElements) {
        return FFT.fftn(Nd4j.createComplex(transform), dimension, numElements);
    }

    public static IComplexNDArray fftn(INDArray transform) {
        return FFT.fftn(transform, transform.shape().length - 1, transform.shape()[transform.shape().length - 1]);
    }

    public static IComplexNDArray fftn(IComplexNDArray transform) {
        return FFT.fftn(transform, transform.shape().length - 1, transform.shape()[transform.shape().length - 1]);
    }

    public static IComplexNDArray ifftn(IComplexNDArray transform, int dimension) {
        return FFT.ifftn(transform, dimension, transform.shape()[dimension]);
    }

    public static IComplexNDArray ifftn(IComplexNDArray transform) {
        return FFT.ifftn(transform, transform.shape().length - 1, transform.size(transform.shape().length - 1));
    }

    public static IComplexNDArray ifftn(INDArray transform) {
        return FFT.ifftn(transform, transform.shape().length - 1, transform.size(transform.shape().length - 1));
    }

    public static IComplexNDArray rawifftn(IComplexNDArray transform, int[] shape, int[] axes) {
        assert (shape.length > 0) : "Shape length must be > 0";
        assert (shape.length == axes.length) : "Axes and shape must be the same length";
        IComplexNDArray result = transform.dup();
        for (int i = shape.length - 1; i >= 0; --i) {
            result = FFT.ifft(result, shape[i], axes[i]);
        }
        return result;
    }

    public static IComplexNDArray rawfftn(IComplexNDArray transform, int[] shape, int[] axes) {
        IComplexNDArray result = transform.dup();
        for (int i = shape.length - 1; i >= 0; --i) {
            result = FFT.fft(result, shape[i], axes[i]);
        }
        return result;
    }

    public static IComplexNDArray rawfft(IComplexNDArray transform, int n, int dimension) {
        IComplexNDArray result = transform.dup();
        if (transform.size(dimension) != n) {
            int[] shape = ArrayUtil.copy(result.shape());
            shape[dimension] = n;
            result = transform.size(dimension) > n ? ComplexNDArrayUtil.truncate(result, n, dimension) : ComplexNDArrayUtil.padWithZeros(result, shape);
        }
        if (dimension != result.shape().length - 1) {
            result = result.swapAxes(result.shape().length - 1, dimension);
        }
        result.iterateOverAllRows(new FFTSliceOp(result.size(result.shape().length - 1)));
        if (dimension != result.shape().length - 1) {
            result = result.swapAxes(result.shape().length - 1, dimension);
        }
        return result;
    }

    public static IComplexNDArray rawifft(IComplexNDArray transform, int n, int dimension) {
        IComplexNDArray result = transform.dup();
        if (transform.size(dimension) != n) {
            int[] shape = ArrayUtil.copy(result.shape());
            shape[dimension] = n;
            result = transform.size(dimension) > n ? ComplexNDArrayUtil.truncate(result, n, dimension) : ComplexNDArrayUtil.padWithZeros(result, shape);
        }
        if (dimension != result.shape().length - 1) {
            result = result.swapAxes(result.shape().length - 1, dimension);
        }
        result.iterateOverAllRows(new IFFTSliceOp(result.size(result.shape().length - 1)));
        if (dimension != result.shape().length - 1) {
            result = result.swapAxes(result.shape().length - 1, dimension);
        }
        return result;
    }

    public static IComplexNDArray rawifft(IComplexNDArray transform, int dimension) {
        return FFT.rawifft(transform, transform.shape()[dimension], dimension);
    }
}

