/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.complex.test;

import org.junit.Assert;
import org.junit.Test;
import org.nd4j.linalg.api.complex.IComplexDouble;
import org.nd4j.linalg.api.complex.IComplexFloat;
import org.nd4j.linalg.factory.Nd4j;

public abstract class ComplexNumberTests {
    @Test
    public void testScalar() {
        IComplexDouble test = Nd4j.createDouble(1.0, 1.0);
        test.addi(1);
        Assert.assertEquals((double)2.0, (double)test.realComponent(), (double)0.1);
        Assert.assertEquals((double)2.0, (double)test.imaginaryComponent(), (double)0.1);
        test.subi(1);
        Assert.assertEquals((double)1.0, (double)test.realComponent(), (double)0.1);
        Assert.assertEquals((double)1.0, (double)test.imaginaryComponent(), (double)0.1);
        test.muli(2);
        Assert.assertEquals((double)2.0, (double)test.realComponent(), (double)0.1);
        Assert.assertEquals((double)2.0, (double)test.imaginaryComponent(), (double)0.1);
        test.divi(2.0);
        Assert.assertEquals((double)1.0, (double)test.realComponent(), (double)0.1);
        Assert.assertEquals((double)1.0, (double)test.imaginaryComponent(), (double)0.1);
    }

    @Test
    public void testScalarFloat() {
        IComplexFloat test = Nd4j.createFloat(1.0f, 1.0f);
        test.addi(1);
        Assert.assertEquals((double)2.0, (double)test.realComponent().doubleValue(), (double)0.1);
        Assert.assertEquals((double)2.0, (double)test.imaginaryComponent().floatValue(), (double)0.1);
        test.subi(1);
        Assert.assertEquals((double)1.0, (double)test.realComponent().doubleValue(), (double)0.1);
        Assert.assertEquals((double)1.0, (double)test.imaginaryComponent().floatValue(), (double)0.1);
        test.muli(2);
        Assert.assertEquals((double)2.0, (double)test.realComponent().doubleValue(), (double)0.1);
        Assert.assertEquals((double)2.0, (double)test.imaginaryComponent().floatValue(), (double)0.1);
        test.divi(2.0f);
        Assert.assertEquals((double)1.0, (double)test.realComponent().doubleValue(), (double)0.1);
        Assert.assertEquals((double)1.0, (double)test.imaginaryComponent().floatValue(), (double)0.1);
    }

    @Test
    public void testComplexComplexOperations() {
        IComplexDouble d = Nd4j.createDouble(2.0, 3.0);
        IComplexDouble d2 = Nd4j.createDouble(4.0, 5.0);
        IComplexDouble d3 = d.mul(d2).asDouble();
    }
}

