/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.cdi;

import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import org.apache.ibatis.session.SqlSessionManager;
import org.mybatis.cdi.SqlSessionManagerRegistry;
import org.mybatis.cdi.Transactional;

@Transactional
@Interceptor
public class LocalTransactionInterceptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    private transient SqlSessionManagerRegistry registry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object invoke(InvocationContext ctx) throws Exception {
        Object result;
        Transactional transactional = this.getTransactionalAnnotation(ctx);
        boolean isInitiator = this.start(transactional);
        boolean isExternalJta = this.isTransactionActive();
        if (isInitiator && !isExternalJta) {
            this.beginJta();
        }
        boolean needsRollback = transactional.rollbackOnly();
        try {
            result = ctx.proceed();
        }
        catch (Exception ex) {
            Exception unwrapped = this.unwrapException(ex);
            needsRollback = needsRollback || this.needsRollback(transactional, unwrapped);
            throw unwrapped;
        }
        finally {
            if (isInitiator) {
                try {
                    if (needsRollback) {
                        this.rollback(transactional);
                    } else {
                        this.commit(transactional);
                    }
                }
                finally {
                    this.close();
                    this.endJta(isExternalJta, needsRollback);
                }
            }
        }
        return result;
    }

    protected boolean isTransactionActive() throws SystemException {
        return false;
    }

    protected void beginJta() throws NotSupportedException, SystemException {
    }

    protected void endJta(boolean isExternaTransaction, boolean commit) throws SystemException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
    }

    private boolean needsRollback(Transactional transactional, Throwable throwable) {
        if (RuntimeException.class.isAssignableFrom(throwable.getClass())) {
            return true;
        }
        for (Class<? extends Throwable> exceptionClass : transactional.rollbackFor()) {
            if (!exceptionClass.isAssignableFrom(throwable.getClass())) continue;
            return true;
        }
        return false;
    }

    protected Transactional getTransactionalAnnotation(InvocationContext ctx) {
        Transactional t = ctx.getMethod().getAnnotation(Transactional.class);
        if (t == null) {
            t = ctx.getMethod().getDeclaringClass().getAnnotation(Transactional.class);
        }
        return t;
    }

    private boolean start(Transactional transactional) {
        boolean started = false;
        for (SqlSessionManager manager : this.registry.getManagers()) {
            if (manager.isManagedSessionStarted()) continue;
            manager.startManagedSession(transactional.executorType(), transactional.isolation().getTransactionIsolationLevel());
            started = true;
        }
        return started;
    }

    private void commit(Transactional transactional) {
        for (SqlSessionManager manager : this.registry.getManagers()) {
            manager.commit(transactional.force());
        }
    }

    private void rollback(Transactional transactional) {
        for (SqlSessionManager manager : this.registry.getManagers()) {
            manager.rollback(transactional.force());
        }
    }

    private void close() {
        for (SqlSessionManager manager : this.registry.getManagers()) {
            manager.close();
        }
    }

    private Exception unwrapException(Exception wrapped) {
        Throwable unwrapped = wrapped;
        while (true) {
            if (unwrapped instanceof InvocationTargetException) {
                unwrapped = ((InvocationTargetException)unwrapped).getTargetException();
                continue;
            }
            if (!(unwrapped instanceof UndeclaredThrowableException)) break;
            unwrapped = ((UndeclaredThrowableException)unwrapped).getUndeclaredThrowable();
        }
        if (!(unwrapped instanceof Exception)) {
            return new RuntimeException(unwrapped);
        }
        return unwrapped;
    }
}

