/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.cdi;

import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.interceptor.Interceptor;
import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.UserTransaction;
import org.mybatis.cdi.LocalTransactionInterceptor;
import org.mybatis.cdi.Transactional;

@Transactional
@Interceptor
public class JtaTransactionInterceptor
extends LocalTransactionInterceptor {
    private static final long serialVersionUID = 1L;
    @Inject
    private transient Instance<UserTransaction> userTransaction;

    @Override
    protected boolean isTransactionActive() throws SystemException {
        return ((UserTransaction)this.userTransaction.get()).getStatus() != 6;
    }

    @Override
    protected void beginJta() throws NotSupportedException, SystemException {
        ((UserTransaction)this.userTransaction.get()).begin();
    }

    @Override
    protected void endJta(boolean isExternaTransaction, boolean needsRollback) throws SystemException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
        if (isExternaTransaction) {
            if (needsRollback) {
                ((UserTransaction)this.userTransaction.get()).setRollbackOnly();
            }
        } else if (needsRollback) {
            ((UserTransaction)this.userTransaction.get()).rollback();
        } else {
            ((UserTransaction)this.userTransaction.get()).commit();
        }
    }
}

