package org.mule.weave.v2.api.tooling.ts

import org.mule.weave.v2.api.tooling.location.Location
import org.mule.weave.v2.api.tooling.location.ResourceIdentifier

import java.util.Optional

trait DWType {
  def getLabel: Optional[String]

  def getTypeMetadataConstraints: Array[DWMetadataConstraint]

  def getTypeMetadataConstraint(name: String): Optional[DWMetadataConstraint]

  def getTypeDocumentation: Optional[String]

  def getTypeMetadata: Array[DWMetadata]

  def getTypeMetadata(name: String): Optional[DWMetadata]

  def isOptional: Boolean

  def getBaseType: DWType = this

  def accept(visitor: DWTypeVisitor): Unit

  def getLocation: Location
}

trait DWMetadataValue {
  def getLocation: Location
}

trait LiteralMetadataValue extends DWMetadataValue {
  def getValue: String

  def getType: DWType
}

trait ArrayMetadataValue extends DWMetadataValue {
  def getElements: Array[DWMetadataValue]
}

trait ObjectMetadataValue extends DWMetadataValue {
  def getProperties: Array[KeyValuePairMetadataValue]
}

trait KeyValuePairMetadataValue extends DWMetadataValue {
  def getKey: String

  def getValue: DWMetadataValue
}

trait VariableReferenceMetadataValue extends DWMetadataValue {
  def getFullyQualifiedName: String
}

trait UnknownMetadataValue extends DWMetadataValue

trait DWMetadata {
  def getName: String

  def getValue: DWMetadataValue
}

trait NumberType extends DWType {
  def getValue: Optional[String]
}

trait KeyValuePairType extends DWType {
  def getKey: DWType

  def getValue: DWType

  def isOptionalKey: Boolean

  def repeated: Boolean

  def getKeyName: String
}

trait ObjectType extends DWType {
  def getProperties: Array[KeyValuePairType]

  def isClosed: Boolean

  def isOrdered: Boolean
}

trait KeyType extends DWType {
  def getName: DWType

  def getAttributes: Array[NameValuePairType]
}

trait NameType extends DWType {
  def getValue: Optional[QName]
}

trait ArrayType extends DWType {
  def arrayOf: DWType
}

trait UnionType extends DWType {
  def unionOf: Array[DWType]
}

trait UriType extends DWType {
  def getValue: Optional[String]
}

trait ReferenceType extends DWType {
  /**
    * The Type expression of the referenced type
    *
    * @return
    */
  def getReferenceTypeName: String

  /**
    * Returns the resolved type
    *
    * @return
    */
  def resolveType(): DWType

  /**
    * The FQN of the referenced Type expression
    *
    * @return
    */
  def getReferenceFQName: String
}

trait SimpleReferenceType extends ReferenceType {
  def getTypeParameters: Optional[Array[DWType]]
}

trait TypeSelectorType extends ReferenceType {
  def getReferencePrefix: Optional[ResourceIdentifier]
}

trait NamespaceType extends DWType {
  def getPrefix: Optional[String]

  def getNamespace: Optional[UriType]
}

trait PeriodType extends DWType

trait BinaryType extends DWType

trait TypeType extends DWType {
  def getType: DWType
}

trait RegexType extends DWType

trait RangeType extends DWType

trait NullType extends DWType

trait NothingType extends DWType

trait DateTimeType extends DWType

trait LocalDateTimeType extends DWType

trait LocalDateType extends DWType

trait LocalTimeType extends DWType

trait TimeType extends DWType

trait TimeZoneType extends DWType

trait AnyType extends DWType

trait FunctionTypeParameter {
  def getName: String

  def getType: DWType

  def isOptional: Boolean

  def getDefaultValueType: Optional[DWType]
}

trait FunctionType extends DWType {

  def getTypeParameters: Array[TypeParameter]

  def getParameters: Array[FunctionTypeParameter]

  def getReturnType: DWType

  def getOverloads: Array[FunctionType]

  def getName: Optional[String]

  def isOverloaded: Boolean
}

trait NameValuePairType extends DWType {
  def getName: DWType

  def getValue: DWType

  def isOptionalPairType: Boolean
}

trait TypeParameter extends DWType {
  def name: String

  def getTopType: Optional[DWType]

  def getBottomType: Optional[DWType]

  def noImplicitBounds: Boolean

  def isAbstract: Boolean
}

trait DynamicReturnType extends DWType {
  def getTypeParameters: Array[FunctionTypeParameter]

  def getName: Optional[String]

  def getExpectedReturnType: Optional[DWType]
}

trait IntersectionType extends DWType {
  def intersectionOf: Array[DWType]
}

trait StringType extends DWType {
  def getValue: Optional[String]
}

trait BooleanType extends DWType {
  def getValue: Optional[Boolean]
}

trait DWMetadataConstraint {
  def getName: String

  def getValue: Any
}

trait QName {
  def getName: String

  def getNamespace: Optional[String]
}
