/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.interpreted.node;

import java.io.Serializable;
import org.mule.weave.v2.interpreted.ExecutionContext;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.types.Type;
import org.mule.weave.v2.model.types.Types$;
import org.mule.weave.v2.model.values.FunctionParameter;
import org.mule.weave.v2.model.values.FunctionValue;
import org.mule.weave.v2.model.values.Value;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;

public final class FunctionDispatchingHelper$ {
    public static FunctionDispatchingHelper$ MODULE$;

    static {
        new FunctionDispatchingHelper$();
    }

    public Option<Tuple2<Object, FunctionValue>> findMatchingFunction(Seq<Value<Object>> arguments, Seq<? extends FunctionValue> options, ExecutionContext ctx) {
        for (int optionIndex = 0; optionIndex < options.length(); ++optionIndex) {
            FunctionValue functionValue = (FunctionValue)options.apply(optionIndex);
            boolean matchesTypes = this.matchesFunctionTypes(functionValue, arguments, ctx);
            if (!matchesTypes) continue;
            return new Some((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)optionIndex), (Object)functionValue));
        }
        return None$.MODULE$;
    }

    public Option<Tuple3<Object, FunctionValue, Seq<Value<?>>>> findMatchingFunctionWithCoercion(Seq<Value<Object>> arguments, Seq<? extends FunctionValue> options, ExecutionContext ctx) {
        ArrayBuffer coercedValues = new ArrayBuffer(arguments.length());
        for (int optionIndex = 0; optionIndex < options.length(); ++optionIndex) {
            int index;
            coercedValues.clear();
            FunctionValue function = (FunctionValue)options.apply(optionIndex);
            if (function.minParams() > arguments.size() || function.maxParams() < arguments.size()) continue;
            boolean matchesTypes = true;
            Seq parameters = function.parameters();
            Seq functionParamTypes = (Seq)parameters.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.wtype(), Seq$.MODULE$.canBuildFrom());
            for (index = 0; arguments.length() > index && matchesTypes; ++index) {
                ArrayBuffer arrayBuffer;
                Type expectedType = (Type)functionParamTypes.apply(index);
                Type actualType = ((Value)arguments.apply(index)).valueType((EvaluationContext)ctx);
                if (!actualType.isInstanceOf(expectedType, (EvaluationContext)ctx)) {
                    try {
                        arrayBuffer = coercedValues.$plus$eq((Object)expectedType.coerce((Value)arguments.apply(index), (EvaluationContext)ctx));
                    }
                    catch (Exception e) {
                        matchesTypes = false;
                        arrayBuffer = BoxedUnit.UNIT;
                    }
                    continue;
                }
                arrayBuffer = coercedValues.$plus$eq(arguments.apply(index));
            }
            if (!matchesTypes) continue;
            return new Some((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)index), (Object)function, (Object)coercedValues));
        }
        return None$.MODULE$;
    }

    public Seq<FunctionValue> sortByParameterTypeWeight(Seq<FunctionValue> functionOverloads, Seq<Type> argTypes, ExecutionContext ctx) {
        Seq weightFunctions = (Seq)functionOverloads.map((Function1 & Serializable & scala.Serializable)operator -> {
            Seq parameterTypes = (Seq)operator.parameters().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.wtype(), Seq$.MODULE$.canBuildFrom());
            DoubleRef weight = DoubleRef.create((double)0.0);
            IntRef miss = IntRef.create((int)0);
            ((IterableLike)parameterTypes.zip((GenIterable)argTypes, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)paramTypeArgType -> {
                FunctionDispatchingHelper$.$anonfun$sortByParameterTypeWeight$3(ctx, weight, miss, paramTypeArgType);
                return BoxedUnit.UNIT;
            });
            return new Tuple3(operator, (Object)BoxesRunTime.boxToDouble((double)weight.elem), (Object)BoxesRunTime.boxToInteger((int)miss.elem));
        }, Seq$.MODULE$.canBuildFrom());
        Seq sortedOperators = (Seq)((TraversableLike)((SeqLike)weightFunctions.sortBy((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToDouble((double)FunctionDispatchingHelper$.$anonfun$sortByParameterTypeWeight$4(v)), (Ordering)Ordering.Double$.MODULE$)).sortBy((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToInteger((int)FunctionDispatchingHelper$.$anonfun$sortByParameterTypeWeight$5(v)), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable & scala.Serializable)v -> (FunctionValue)v._1(), Seq$.MODULE$.canBuildFrom());
        return sortedOperators;
    }

    public Option<Seq<Value<?>>> tryToCoerce(Seq<Value<?>> argumentsWithDefaults, FunctionValue dispatch, ExecutionContext ctx) {
        ArrayBuffer result = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        for (int i = 0; dispatch.parameters().length() > i; ++i) {
            ArrayBuffer arrayBuffer;
            Value value;
            Type expectedType = ((FunctionParameter)dispatch.parameters().apply(i)).wtype();
            if (!expectedType.accepts(value = (Value)argumentsWithDefaults.apply(i), (EvaluationContext)ctx)) {
                Option valueMaybe = expectedType.coerceMaybe(value, (EvaluationContext)ctx);
                if (valueMaybe.isDefined()) {
                    arrayBuffer = result.$plus$eq(valueMaybe.get());
                    continue;
                }
                return None$.MODULE$;
            }
            arrayBuffer = result.$plus$eq((Object)value);
        }
        return new Some((Object)result);
    }

    public boolean matchesFunctionTypes(FunctionValue functionValue, Seq<Value<Object>> arguments, ExecutionContext ctx) {
        Seq parameters = functionValue.parameters();
        return this.matchesParameters((Seq<FunctionParameter>)parameters, arguments, ctx);
    }

    public boolean matchesParameters(Seq<FunctionParameter> parameters, Seq<Value<Object>> arguments, ExecutionContext ctx) {
        int delta;
        Tuple2 parameterSplit;
        int delta2;
        Tuple2 parameterSplit2;
        boolean matchesTypes = true;
        matchesTypes = parameters.size() == arguments.length() ? Types$.MODULE$.validate((Seq)parameters.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.wtype(), Seq$.MODULE$.canBuildFrom()), arguments, (EvaluationContext)ctx) : (((FunctionParameter)parameters.head()).value().nonEmpty() ? !((IterableLike)(parameterSplit2 = parameters.splitAt(delta2 = parameters.length() - arguments.size()))._1()).exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)FunctionDispatchingHelper$.$anonfun$matchesParameters$2(x$4))) && this.matchesParameters((Seq<FunctionParameter>)((Seq)parameterSplit2._2()), arguments, ctx) : (((FunctionParameter)parameters.last()).value().nonEmpty() ? !((IterableLike)(parameterSplit = parameters.splitAt(delta = parameters.length() - arguments.size()))._2()).exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)FunctionDispatchingHelper$.$anonfun$matchesParameters$3(x$5))) && this.matchesParameters((Seq<FunctionParameter>)((Seq)parameterSplit._1()), arguments, ctx) : false));
        return matchesTypes;
    }

    public final Seq<Value<?>> expandArguments(Seq<Value<?>> arguments, FunctionValue function, ExecutionContext ctx) {
        Seq<Value<?>> seq;
        Seq parameters = function.parameters();
        if (arguments.size() != parameters.size()) {
            Seq paramsWithIndex = (Seq)parameters.zipWithIndex(Seq$.MODULE$.canBuildFrom());
            seq = ((FunctionParameter)parameters.head()).value().isDefined() ? this.expandArgsFromHead((Seq<Tuple2<FunctionParameter, Object>>)paramsWithIndex, arguments, ctx) : this.expandArgsFromTail((Seq<Tuple2<FunctionParameter, Object>>)paramsWithIndex, arguments, ctx);
        } else {
            seq = arguments;
        }
        return seq;
    }

    private Seq<Value<?>> expandArgsFromHead(Seq<Tuple2<FunctionParameter, Object>> paramsWithIndex, Seq<Value<?>> arguments, ExecutionContext ctx) {
        int paramsCount = paramsWithIndex.length();
        return (Seq)paramsWithIndex.map((Function1 & Serializable & scala.Serializable)param -> {
            Value value;
            int delta;
            int index = param._2$mcI$sp();
            if (index < (delta = paramsCount - arguments.size())) {
                Value v;
                Option defaultValue = ((FunctionParameter)param._1()).value().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.value((EvaluationContext)ctx));
                Option option = defaultValue;
                if (!(option instanceof Some)) {
                    throw new RuntimeException("Please verify function arity before trying to expand");
                }
                Some some = (Some)option;
                Value value2 = v = (Value)some.value();
                value = value2;
            } else if (index < paramsCount) {
                value = (Value)arguments.apply(index - delta);
            } else {
                throw new RuntimeException("Please verify function arity before trying to expand");
            }
            return value;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Seq<Value<?>> expandArgsFromTail(Seq<Tuple2<FunctionParameter, Object>> paramsWithIndex, Seq<Value<?>> arguments, ExecutionContext ctx) {
        return (Seq)paramsWithIndex.map((Function1 & Serializable & scala.Serializable)param -> {
            Value value;
            int index = param._2$mcI$sp();
            if (index < arguments.size()) {
                value = (Value)arguments.apply(index);
            } else {
                Value v;
                Option defaultValue = ((FunctionParameter)param._1()).value().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.value((EvaluationContext)ctx));
                Option option = defaultValue;
                if (!(option instanceof Some)) {
                    throw new RuntimeException("Please verify function arity before trying to expand");
                }
                Some some = (Some)option;
                Value value2 = v = (Value)some.value();
                value = value2;
            }
            return value;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$sortByParameterTypeWeight$3(ExecutionContext ctx$1, DoubleRef weight$1, IntRef miss$1, Tuple2 paramTypeArgType) {
        block0: {
            if (((Type)paramTypeArgType._2()).isInstanceOf((Type)paramTypeArgType._1(), (EvaluationContext)ctx$1)) break block0;
            ++miss$1.elem;
            weight$1.elem += (double)((Type)paramTypeArgType._1()).weight();
        }
    }

    public static final /* synthetic */ double $anonfun$sortByParameterTypeWeight$4(Tuple3 v) {
        return BoxesRunTime.unboxToDouble((Object)v._2());
    }

    public static final /* synthetic */ int $anonfun$sortByParameterTypeWeight$5(Tuple3 v) {
        return BoxesRunTime.unboxToInt((Object)v._3());
    }

    public static final /* synthetic */ boolean $anonfun$matchesParameters$2(FunctionParameter x$4) {
        return x$4.value().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$matchesParameters$3(FunctionParameter x$5) {
        return x$5.value().isEmpty();
    }

    private FunctionDispatchingHelper$() {
        MODULE$ = this;
    }
}

