package org.mule.weave.v2.module.pojo.writer.converter

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema
import org.mule.weave.v2.module.commons.java.writer.converter.DataConverter

class ClassDataConverter extends DataConverter[Class[_]] {
  override def convert(source: Any, schema: Option[Schema])(implicit ctx: EvaluationContext): Option[Class[_]] = {
    val to: Option[_] = JavaDataConverter.to[String](source, None, classOf[String])
    to match {
      case Some(className) => {
        Some(Thread.currentThread().getContextClassLoader.loadClass(className.toString))
      }
      case _ => None
    }

  }
}
