package org.mule.weave.v2.module.pojo.reader

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.module.DataFormat
import org.mule.weave.v2.module.commons.java.reader.BaseJavaReader
import org.mule.weave.v2.module.commons.java.value.JavaValueConverter
import org.mule.weave.v2.module.pojo.JavaDataFormat

class JavaReader(val rootValue: Any)(implicit ctx: EvaluationContext) extends BaseJavaReader {
  override def context: EvaluationContext = ctx

  override def converter: JavaValueConverter = ReflectionJavaValueConverter

  override def dataFormat: Option[DataFormat[_, _]] = Some(new JavaDataFormat)
}

object JavaReader {
  def apply(value: Any)(implicit ctx: EvaluationContext): JavaReader = {
    new JavaReader(value)
  }
}

