package org.mule.weave.v2.module.pojo.reader

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.BoundedArraySeq
import org.mule.weave.v2.model.values.Value

class JavaArrayJavaValue(array: Array[_], val locationString: () => String)(implicit ctx: EvaluationContext) extends JavaArrayValue {

  private lazy val value = new JavaArrayArraySeq(array, locationString)

  override def evaluate(implicit ctx: EvaluationContext): T = {
    value
  }

  override def underlying()(implicit ctx: EvaluationContext): Any = array

  private class JavaArrayArraySeq(entries: Array[_], val locationString: () => String) extends BoundedArraySeq {

    override def toIterator(): Iterator[Value[_]] = {
      val v = entries.iterator
      new Iterator[Value[_]] {
        override def hasNext: Boolean = v.hasNext
        override def next(): Value[_] = ReflectionJavaValueConverter.convert(v.next(), locationString)
      }
    }

    override def toSeq(): Seq[Value[_]] = {
      toArray().toSeq
    }

    override def toArray(): Array[Value[_]] = {
      val result = new Array[Value[_]](entries.length)
      val iterator = toIterator()
      var i = 0
      while (iterator.hasNext) {
        val nextValue = iterator.next()
        result.update(i, nextValue)
        i = i + 1
      }
      result
    }

    override def apply(index: Long)(implicit ctx: EvaluationContext): Option[Value[_]] = {
      if (index >= 0 && index < size()) {
        Some(ReflectionJavaValueConverter.convert(array(index.toInt), locationString))
      } else {
        None
      }
    }

    override def size(): Long = entries.length
    override def materialized(): Boolean = true
  }

}
