package org.mule.weave.v2.module.pojo

import org.mule.weave.v2.core.util.ExceptionHelper
import org.mule.weave.v2.module.pojo.exception.ClassLoaderName
import org.mule.weave.v2.module.pojo.exception.ClassNotFoundException
import org.mule.weave.v2.parser.location.UnknownLocation

import java.util.logging.Level
import java.util.logging.Logger
import scala.util.Failure
import scala.util.Success
import scala.util.Try

/**
  * Service that loads class
  */
trait ClassLoaderService {
  def loadClass(className: String): Option[Class[_]]
}

object DefaultClassLoaderService extends ClassLoaderService {
  private val logger: Logger = Logger.getLogger(DefaultClassLoaderService.getClass.getName)

  override def loadClass(className: String): Option[Class[_]] = {
    val maybe = Try(Thread.currentThread().getContextClassLoader.loadClass(className)).orElse(Try(getClass.getClassLoader.loadClass(className)))
    maybe match {
      case Success(value) =>
        Some(value)

      case Failure(_) =>
        val exception = new ClassNotFoundException(UnknownLocation, className,
          Seq(
            ClassLoaderName("ContextClassLoader", Thread.currentThread().getContextClassLoader.getClass.getName),
            ClassLoaderName("CurrentClassLoader", getClass.getClassLoader.getClass.getName)))
        logger.log(Level.WARNING, ExceptionHelper.getStackTraceString(exception))
        None
    }
  }
}
