package org.mule.weave.v2.module.pojo

import org.mule.weave.v2.core.env.WeaveRuntime
import org.mule.weave.v2.model.service.SettingsService

trait ClassBeanDefinitionLookup {
  def lookup(clazz: Class[_], settingsService: SettingsService): Option[Class[_]] = {
    if (settingsService.java().enabledClassDefinitionLookup) {
      doLookup(clazz)
    } else {
      None
    }
  }

  def doLookup(clazz: Class[_]): Option[Class[_]]
}

class DefaultClassBeanDefinitionLookup extends ClassBeanDefinitionLookup {
  private val CLASSES: Set[Class[_]] = Set(classOf[Process])

  override def doLookup(clazz: Class[_]): Option[Class[_]] = {
    CLASSES.find(_.isAssignableFrom(clazz))
  }
}

object ClassBeanDefinitionLookup {

  private lazy val strategies: Seq[ClassBeanDefinitionLookup] = WeaveRuntime
    .getServiceProvider()
    .serviceImplementations(classOf[ClassBeanDefinitionLookup])

  def getClassDefinition(clazz: Class[_], settingsService: SettingsService): Class[_] = {
    val it = strategies.iterator
    var found: Class[_] = null
    while (found == null && it.hasNext) {
      val strategy = it.next()
      val maybeClazz = strategy.lookup(clazz, settingsService)
      if (maybeClazz.isDefined) {
        found = maybeClazz.get
      }
    }
    if (found != null) {
      found
    } else {
      clazz
    }
  }
}