package org.mule.weave.v2.module.java

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.module.commons.java.JavaClassLoaderHelper
import org.mule.weave.v2.module.pojo.exception.ClassNotFoundException
import org.mule.weave.v2.parser.location.LocationCapable

object ReflectionJavaClassLoaderHelper extends JavaClassLoaderHelper {
  override def doLoadClass(className: String, loader: Option[ClassLoader], location: LocationCapable)(implicit ctx: EvaluationContext): Class[_] =
    className match {
      case "short[]"   => Class.forName("[S")
      case "int[]"     => Class.forName("[I")
      case "long[]"    => Class.forName("[J")
      case "float[]"   => Class.forName("[F")
      case "double[]"  => Class.forName("[D")
      case "byte[]"    => Class.forName("[B")
      case "char[]"    => Class.forName("[C")
      case "boolean[]" => Class.forName("[Z")
      case _ if className.endsWith("[]") =>
        validateRequiredLoadClassPrivilege(location)
        try {
          Class.forName("[L" + className.substring(0, className.length - "[]".length) + ";", true, loader.get)
        } catch {
          case _: Exception => throw new ClassNotFoundException(location.location(), className, loader.get)
        }
      case _ =>
        validateRequiredLoadClassPrivilege(location)
        try {
          Class.forName(className, true, loader.get)
        } catch {
          case _: Exception => throw new ClassNotFoundException(location.location(), className, loader.get)
        }
    }
}
