package org.mule.weave.v2.module.commons.java.writer.converter

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema

import java.time.ZoneId
import java.time.ZoneOffset
import java.util.TimeZone

class ZoneIdDataConverter extends DataConverter[ZoneId] {
  override def convert(source: Any, schema: Option[Schema])(implicit ctx: EvaluationContext): Option[ZoneId] = {
    source match {
      case zone: ZoneOffset   => Option(zone)
      case timeZone: TimeZone => Option(timeZone.toZoneId)
      case _                  => None
    }
  }
}
