package org.mule.weave.v2.module.commons.java.writer.converter

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema
import org.mule.weave.v2.module.commons.java.writer.converter.BaseJavaDataConverter.DateDataConverter$

import java.sql.Timestamp
import java.util

class SqlTimestampDataConverter extends DataConverter[Timestamp] {
  override def convert(source: Any, schema: Option[Schema])(implicit ctx: EvaluationContext): Option[Timestamp] = {
    source match {
      case x: Timestamp => Some(x)
      case _ => {
        val maybeDate: Option[util.Date] = DateDataConverter$.convert(source, schema)
        if (maybeDate.isDefined) {
          Option(new Timestamp(maybeDate.get.getTime))
        } else {
          None
        }
      }
    }

  }
}
