package org.mule.weave.v2.module.commons.java.writer.converter

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema

import java.util.OptionalInt

class OptionalIntDataConverter extends DataConverter[OptionalInt] {

  override def convert(source: Any, schema: Option[Schema])(implicit ctx: EvaluationContext): Option[OptionalInt] = {
    //Makes sure that we are wrapping a java value
    if (source == null) {
      Some(OptionalInt.empty())
    } else {
      val converter = new IntDataConverter()
      converter
        .convert(source, schema)
        .map((intValue) => OptionalInt.of(intValue))
    }
  }
}
