package org.mule.weave.v2.module.commons.java.writer.converter

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema
import org.mule.weave.v2.model.values.math.Number

class FloatDataConverter extends DataConverter[Float] {
  override def convert(source: Any, schema: Option[Schema])(implicit ctx: EvaluationContext): Option[Float] = {
    source match {
      case l: Long                  => Option(l.toFloat)
      case i: Int                   => Option(i.toFloat)
      case d: Double                => Option(d.toFloat)
      case d: Float                 => Option(d)
      case s: Short                 => Option(s.toFloat)
      case n: Number                => Option(n.toFloat)
      case bd: java.math.BigDecimal => Option(bd.floatValue())
      case bi: java.math.BigInteger => Option(bi.floatValue())
      case str: String              => Option(str.toFloat)
      case _                        => None
    }

  }
}
