package org.mule.weave.v2.module.commons.java.writer.converter

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema
import org.mule.weave.v2.module.commons.java.JavaTypesHelper.enumValueOf
import org.mule.weave.v2.module.commons.java.JavaTypesHelper.isAtomicBoolean
import org.mule.weave.v2.module.commons.java.JavaTypesHelper.isAtomicInteger
import org.mule.weave.v2.module.commons.java.JavaTypesHelper.isAtomicLong
import org.mule.weave.v2.module.commons.java.JavaTypesHelper.isBigDecimal
import org.mule.weave.v2.module.commons.java.JavaTypesHelper.isBigInteger
import org.mule.weave.v2.module.commons.java.JavaTypesHelper.isBlob
import org.mule.weave.v2.module.commons.java.JavaTypesHelper.isBoolean
import org.mule.weave.v2.module.commons.java.JavaTypesHelper.isByte
import org.mule.weave.v2.module.commons.java.JavaTypesHelper.isByteArray
import org.mule.weave.v2.module.commons.java.JavaTypesHelper.isByteBuffer
import org.mule.weave.v2.module.commons.java.JavaTypesHelper.isCalendar
import org.mule.weave.v2.module.commons.java.JavaTypesHelper.isChar
import org.mule.weave.v2.module.commons.java.JavaTypesHelper.isClob
import org.mule.weave.v2.module.commons.java.JavaTypesHelper.isDate
import org.mule.weave.v2.module.commons.java.JavaTypesHelper.isDouble
import org.mule.weave.v2.module.commons.java.JavaTypesHelper.isEnum
import org.mule.weave.v2.module.commons.java.JavaTypesHelper.isFloat
import org.mule.weave.v2.module.commons.java.JavaTypesHelper.isInputStream
import org.mule.weave.v2.module.commons.java.JavaTypesHelper.isInstant
import org.mule.weave.v2.module.commons.java.JavaTypesHelper.isInt
import org.mule.weave.v2.module.commons.java.JavaTypesHelper.isLong
import org.mule.weave.v2.module.commons.java.JavaTypesHelper.isNumber
import org.mule.weave.v2.module.commons.java.JavaTypesHelper.isOptional
import org.mule.weave.v2.module.commons.java.JavaTypesHelper.isOptionalDouble
import org.mule.weave.v2.module.commons.java.JavaTypesHelper.isOptionalInt
import org.mule.weave.v2.module.commons.java.JavaTypesHelper.isOptionalLong
import org.mule.weave.v2.module.commons.java.JavaTypesHelper.isReader
import org.mule.weave.v2.module.commons.java.JavaTypesHelper.isShort
import org.mule.weave.v2.module.commons.java.JavaTypesHelper.isSmallByteArray
import org.mule.weave.v2.module.commons.java.JavaTypesHelper.isSqlDate
import org.mule.weave.v2.module.commons.java.JavaTypesHelper.isSqlTime
import org.mule.weave.v2.module.commons.java.JavaTypesHelper.isSqlTimestamp
import org.mule.weave.v2.module.commons.java.JavaTypesHelper.isString
import org.mule.weave.v2.module.commons.java.JavaTypesHelper.isTimeZone
import org.mule.weave.v2.module.commons.java.JavaTypesHelper.isUUID
import org.mule.weave.v2.module.commons.java.JavaTypesHelper.isXmlCalendar
import org.mule.weave.v2.module.commons.java.JavaTypesHelper.isZoneId

import java.io.InputStream
import java.io.Reader
import java.nio.ByteBuffer
import java.sql.Blob
import java.sql.Clob
import java.util.Calendar
import java.util.Date
import java.util.Optional
import java.util.OptionalDouble
import java.util.OptionalInt
import java.util.OptionalLong
import java.util.TimeZone
import java.util.UUID
import java.util.concurrent.atomic.AtomicBoolean
import java.util.concurrent.atomic.AtomicInteger
import java.util.concurrent.atomic.AtomicLong
import javax.xml.datatype.XMLGregorianCalendar

trait BaseJavaDataConverter {
  implicit object AtomicBooleanDataConverter extends AtomicBooleanDataConverter

  implicit object AtomicIntegerDataConverter$ extends AtomicIntegerDataConverter

  implicit object AtomicLongDataConverter$ extends AtomicLongDataConverter

  implicit object BigDecimalDataConverter$ extends BigDecimalDataConverter

  implicit object BigIntegerDataConverter$ extends BigIntegerDataConverter

  implicit object BooleanDataConverter$ extends BooleanDataConverter

  implicit object ByteArrayDataConverter$ extends ByteArrayDataConverter

  implicit object ByteWrapperArrayDataConverter$ extends ByteWrapperArrayDataConverter

  implicit object ByteBufferDataConverter$ extends ByteBufferDataConverter

  implicit object ByteDataConverter$ extends ByteDataConverter

  implicit object CalendarDataConverter$ extends CalendarDataConverter

  implicit object CharDataConverter$ extends CharDataConverter

  implicit object DateDataConverter$ extends DateDataConverter

  implicit object DoubleDataConverter$ extends DoubleDataConverter

  implicit object FloatDataConverter$ extends FloatDataConverter

  implicit object InputStreamDataConverter$ extends InputStreamDataConverter

  implicit object InstantDataConverter$ extends InstantDataConverter

  implicit object IntDataConverter$ extends IntDataConverter

  implicit object LongDataConverter$ extends LongDataConverter

  implicit object NumberConverter$ extends NumberConverter

  implicit object OptionalDataConverter$ extends OptionalDataConverter

  implicit object OptionalDoubleDataConverter$ extends OptionalDoubleDataConverter

  implicit object OptionalIntDataConverter$ extends OptionalIntDataConverter

  implicit object OptionalLongDataConverter$ extends OptionalLongDataConverter

  implicit object ReaderDataConverter$ extends ReaderDataConverter

  implicit object ShortDataConverter$ extends ShortDataConverter

  implicit object SqlDateDataConverter extends SqlDateDataConverter

  implicit object SqlTimeDataConverter$ extends SqlTimeDataConverter

  implicit object SqlTimestampDataConverter$ extends SqlTimestampDataConverter

  implicit object StringDataConverter$ extends StringDataConverter

  implicit object TimeZoneDataConverter$ extends TimeZoneDataConverter

  implicit object UUIDDataConverter$ extends UUIDDataConverter

  implicit object XmlGregorianCalendarDataConverter$ extends XmlGregorianCalendarDataConverter

  implicit object ZoneIdDataConverter$ extends ZoneIdDataConverter

  def to[_](value: Any, schema: Option[Schema], clazz: Class[_])(implicit ctx: EvaluationContext): Option[_] = {
    if (value == null) {
      if (isOptional(clazz)) {
        Some(Optional.empty())
      } else if (isOptionalInt(clazz)) {
        DataConverter.to[OptionalInt](value, schema)
      } else if (isOptionalLong(clazz)) {
        DataConverter.to[OptionalLong](value, schema)
      } else if (isOptionalDouble(clazz)) {
        DataConverter.to[OptionalDouble](value, schema)
      } else {
        Some(value)
      }
    } else {
      if (isSmallByteArray(clazz)) {
        DataConverter.to[Array[Byte]](value, schema)
      } else if (isByteArray(clazz)) {
        DataConverter.to[Array[java.lang.Byte]](value, schema)
      } else if (isInputStream(clazz)) {
        DataConverter.to[InputStream](value, schema)
      } else if (isByteBuffer(clazz)) {
        DataConverter.to[ByteBuffer](value, schema)
      } else if (isChar(clazz)) {
        DataConverter.to[Char](value, schema)
      } else if (isByte(clazz)) {
        DataConverter.to[Byte](value, schema)
      } else if (isBoolean(clazz)) {
        DataConverter.to[Boolean](value, schema)
      } else if (isAtomicBoolean(clazz)) {
        DataConverter.to[AtomicBoolean](value, schema)
      } else if (isNumber(clazz)) {
        DataConverter.to[java.lang.Number](value, schema)
      } else if (isLong(clazz)) {
        DataConverter.to[Long](value, schema)
      } else if (isInt(clazz)) {
        DataConverter.to[Int](value, schema)
      } else if (isShort(clazz)) {
        DataConverter.to[Short](value, schema)
      } else if (isDouble(clazz)) {
        DataConverter.to[Double](value, schema)
      } else if (isFloat(clazz)) {
        DataConverter.to[Float](value, schema)
      } else if (isAtomicInteger(clazz)) {
        DataConverter.to[AtomicInteger](value, schema)
      } else if (isAtomicLong(clazz)) {
        DataConverter.to[AtomicLong](value, schema)
      } else if (isOptional(clazz)) {
        DataConverter.to[Optional[_]](value, schema)
      } else if (isOptionalInt(clazz)) {
        DataConverter.to[OptionalInt](value, schema)
      } else if (isOptionalLong(clazz)) {
        DataConverter.to[OptionalLong](value, schema)
      } else if (isOptionalDouble(clazz)) {
        DataConverter.to[OptionalDouble](value, schema)
      } else if (isCalendar(clazz)) {
        DataConverter.to[Calendar](value, schema)
      } else if (isXmlCalendar(clazz)) {
        DataConverter.to[XMLGregorianCalendar](value, schema)
      } else if (isDate(clazz)) {
        DataConverter.to[Date](value, schema)
      } else if (isSqlDate(clazz)) {
        DataConverter.to[java.sql.Date](value, schema)
      } else if (isSqlTime(clazz)) {
        DataConverter.to[java.sql.Time](value, schema)
      } else if (isSqlTimestamp(clazz)) {
        DataConverter.to[java.sql.Timestamp](value, schema)
      } else if (isInstant(clazz)) {
        DataConverter.to[java.time.Instant](value, schema)
      } else if (isZoneId(clazz)) {
        DataConverter.to[java.time.ZoneId](value, schema)
      } else if (isTimeZone(clazz)) {
        DataConverter.to[TimeZone](value, schema)
      } else if (isBigInteger(clazz)) {
        DataConverter.to[java.math.BigInteger](value, schema)
      } else if (isBigDecimal(clazz)) {
        DataConverter.to[java.math.BigDecimal](value, schema)
      } else if (isUUID(clazz)) {
        DataConverter.to[UUID](value, schema)
      } else if (isEnum(clazz)) {
        enumValueOf(clazz, value.toString)
      } else if (isString(clazz)) {
        DataConverter.to[java.lang.String](value, schema)
      } else if (isReader(clazz)) {
        DataConverter.to[Reader](value, schema)
      } else {
        None
      }
    }
  }
}

object BaseJavaDataConverter extends BaseJavaDataConverter