package org.mule.weave.v2.module.commons.java.writer.converter

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema

import java.util.concurrent.atomic.AtomicBoolean

class AtomicBooleanDataConverter extends DataConverter[AtomicBoolean] {
  override def convert(source: Any, schema: Option[Schema])(implicit ctx: EvaluationContext): Option[AtomicBoolean] = {
    val booleanConverter = new BooleanDataConverter
    booleanConverter.convert(source, schema).map(new AtomicBoolean(_))
  }
}
