package org.mule.weave.v2.module.commons.java.value

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.ObjectSeq
import org.mule.weave.v2.model.values.ObjectValue

trait JavaObjectValue extends ObjectValue with JavaValue[ObjectSeq] {
  def underlyingClass(implicit ctx: EvaluationContext): Class[_] = underlying().getClass
}

class SimpleJavaObjectValue(valueProvider: (EvaluationContext) => ObjectSeq, val _underlying: Any, val locationString: () => String) extends JavaObjectValue {
  override def evaluate(implicit ctx: EvaluationContext): T = valueProvider(ctx)
  override def underlying()(implicit ctx: EvaluationContext): Any = _underlying
}

object SimpleJavaObjectValue {
  def apply(valueProvider: (EvaluationContext) => ObjectSeq, underlying: Any, locationString: () => String): SimpleJavaObjectValue =
    new SimpleJavaObjectValue(valueProvider, underlying, locationString)
}