/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.dwb.reader.memory;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Map;
import org.mule.weave.v2.core.io.SeekableStream;
import org.mule.weave.v2.dwb.api.IWeaveValue;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.capabilities.UnknownLocationCapable$;
import org.mule.weave.v2.model.structure.ArraySeq$;
import org.mule.weave.v2.model.structure.KeyValuePair;
import org.mule.weave.v2.model.structure.KeyValuePair$;
import org.mule.weave.v2.model.structure.NameSeq;
import org.mule.weave.v2.model.structure.NameValuePair;
import org.mule.weave.v2.model.structure.Namespace;
import org.mule.weave.v2.model.structure.ObjectSeq;
import org.mule.weave.v2.model.structure.ObjectSeq$;
import org.mule.weave.v2.model.structure.QualifiedName;
import org.mule.weave.v2.model.structure.schema.Schema;
import org.mule.weave.v2.model.structure.schema.Schema$;
import org.mule.weave.v2.model.structure.schema.SchemaProperty$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.values.ArrayValue;
import org.mule.weave.v2.model.values.AttributesValue$;
import org.mule.weave.v2.model.values.BinaryValue$;
import org.mule.weave.v2.model.values.BooleanValue$;
import org.mule.weave.v2.model.values.DateTimeValue$;
import org.mule.weave.v2.model.values.KeyValue;
import org.mule.weave.v2.model.values.KeyValue$;
import org.mule.weave.v2.model.values.LocalDateTimeValue$;
import org.mule.weave.v2.model.values.LocalDateValue;
import org.mule.weave.v2.model.values.LocalDateValue$;
import org.mule.weave.v2.model.values.LocalTimeValue$;
import org.mule.weave.v2.model.values.MaterializedObjectValue;
import org.mule.weave.v2.model.values.MaterializedObjectValue$;
import org.mule.weave.v2.model.values.NullValue$;
import org.mule.weave.v2.model.values.NumberValue$;
import org.mule.weave.v2.model.values.ObjectValue;
import org.mule.weave.v2.model.values.PeriodValue$;
import org.mule.weave.v2.model.values.RangeValue$;
import org.mule.weave.v2.model.values.RegexValue$;
import org.mule.weave.v2.model.values.StringValue;
import org.mule.weave.v2.model.values.StringValue$;
import org.mule.weave.v2.model.values.TimeValue$;
import org.mule.weave.v2.model.values.TimeZoneValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.model.values.math.Number$;
import org.mule.weave.v2.module.core.json.reader.memory.InMemoryJsonArray;
import org.mule.weave.v2.module.dwb.DwTokenHelper$;
import org.mule.weave.v2.module.dwb.DwTokenType$;
import org.mule.weave.v2.module.dwb.reader.WeaveBinaryParser;
import org.mule.weave.v2.module.dwb.reader.WeaveValue$;
import org.mule.weave.v2.module.dwb.reader.exceptions.DWBRuntimeExecutionException;
import org.mule.weave.v2.module.dwb.reader.exceptions.DWBRuntimeExecutionException$;
import org.mule.weave.v2.module.dwb.reader.indexed.BinaryValueRetriever$;
import org.mule.weave.v2.module.dwb.reader.memory.RedefinedObjectSeq;
import org.mule.weave.v2.parser.location.Location;
import org.mule.weave.v2.parser.location.LocationCapable;
import org.mule.weave.v2.parser.location.UnknownLocation$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015h\u0001\u0002\u0012$\u0001QB\u0001b\u0010\u0001\u0003\u0006\u0004%\t\u0001\u0011\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u0003\"AQ\n\u0001BC\u0002\u0013\u0005a\n\u0003\u0005X\u0001\t\u0005\t\u0015!\u0003P\u0011!A\u0006A!A!\u0002\u0017I\u0006\"B0\u0001\t\u0003\u0001\u0007bB4\u0001\u0005\u0004%I\u0001\u001b\u0005\u0007a\u0002\u0001\u000b\u0011B5\t\u000fE\u0004!\u0019!C\u0005e\"9\u00111\u0001\u0001!\u0002\u0013\u0019\b\"CA\u0003\u0001\t\u0007I\u0011BA\u0004\u0011!\tY\u0001\u0001Q\u0001\n\u0005%\u0001\"CA\u0007\u0001\t\u0007I\u0011BA\b\u0011!\ty\u0003\u0001Q\u0001\n\u0005E\u0001\"CA\u0019\u0001\t\u0007I\u0011BA\u001a\u0011!\ti\u0004\u0001Q\u0001\n\u0005U\u0002bBA \u0001\u0011\u0005\u0011\u0011\t\u0005\b\u0003\u0013\u0002A\u0011AA&\u0011\u001d\t\t\b\u0001C\u0001\u0003gBq!!!\u0001\t\u0003\t\u0019\tC\u0004\u0002\f\u0002!\t!!$\t\u000f\u0005u\u0005\u0001\"\u0003\u0002 \"9\u0011\u0011\u0015\u0001\u0005\u0002\u0005}\u0005bBAR\u0001\u0011\u0005\u0011Q\u0015\u0005\b\u0003O\u0003A\u0011BAU\u0011\u001d\t\t\f\u0001C\u0005\u0003gCq!a/\u0001\t\u0013\ti\fC\u0004\u0002H\u0002!I!!3\t\u000f\u00055\u0007\u0001\"\u0003\u0002P\"9\u0011\u0011\u001c\u0001\u0005\u0002\u0005}\u0005bBAn\u0001\u0011%\u0011Q\u0015\u0005\b\u0003;\u0004A\u0011BAp\u0011\u001d\t\t\u000f\u0001C\u0005\u0003G\u0014\u0011$\u00138NK6|'/_,fCZ,')\u001b8bef\u0004\u0016M]:fe*\u0011A%J\u0001\u0007[\u0016lwN]=\u000b\u0005\u0019:\u0013A\u0002:fC\u0012,'O\u0003\u0002)S\u0005\u0019Am\u001e2\u000b\u0005)Z\u0013AB7pIVdWM\u0003\u0002-[\u0005\u0011aO\r\u0006\u0003]=\nQa^3bm\u0016T!\u0001M\u0019\u0002\t5,H.\u001a\u0006\u0002e\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!N\u001e\u0011\u0005YJT\"A\u001c\u000b\u0003a\nQa]2bY\u0006L!AO\u001c\u0003\r\u0005s\u0017PU3g!\taT(D\u0001&\u0013\tqTEA\tXK\u00064XMQ5oCJL\b+\u0019:tKJ\fAA\\1nKV\t\u0011\t\u0005\u0002C\u0013:\u00111i\u0012\t\u0003\t^j\u0011!\u0012\u0006\u0003\rN\na\u0001\u0010:p_Rt\u0014B\u0001%8\u0003\u0019\u0001&/\u001a3fM&\u0011!j\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005!;\u0014!\u00028b[\u0016\u0004\u0013aC5oaV$8\u000b\u001e:fC6,\u0012a\u0014\t\u0003!Vk\u0011!\u0015\u0006\u0003%N\u000b!![8\u000b\u0005Q[\u0013\u0001B2pe\u0016L!AV)\u0003\u001dM+Wm[1cY\u0016\u001cFO]3b[\u0006a\u0011N\u001c9viN#(/Z1nA\u0005\u00191\r\u001e=\u0011\u0005ikV\"A.\u000b\u0005q[\u0013!B7pI\u0016d\u0017B\u00010\\\u0005E)e/\u00197vCRLwN\\\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u0005,g\r\u0006\u0002cIB\u00111\rA\u0007\u0002G!)\u0001L\u0002a\u00023\")qH\u0002a\u0001\u0003\")QJ\u0002a\u0001\u001f\u0006)\u0011N\u001c9viV\t\u0011\u000e\u0005\u0002k]6\t1N\u0003\u0002SY*\tQ.\u0001\u0003kCZ\f\u0017BA8l\u0005=!\u0015\r^1J]B,Ho\u0015;sK\u0006l\u0017AB5oaV$\b%\u0001\u0006oC6,7\u000f]1dKN,\u0012a\u001d\t\u0004if\\X\"A;\u000b\u0005Y<\u0018aB7vi\u0006\u0014G.\u001a\u0006\u0003q^\n!bY8mY\u0016\u001cG/[8o\u0013\tQXOA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bC\u0001?\u0000\u001b\u0005i(B\u0001@\\\u0003%\u0019HO];diV\u0014X-C\u0002\u0002\u0002u\u0014\u0011BT1nKN\u0004\u0018mY3\u0002\u00179\fW.Z:qC\u000e,7\u000fI\u0001\u0006]\u0006lWm]\u000b\u0003\u0003\u0013\u00012\u0001^=B\u0003\u0019q\u0017-\\3tA\u00059!p\u001c8f\u0013\u0012\u001cXCAA\t!\u001d!\u00181CA\f\u0003GI1!!\u0006v\u0005\u001dA\u0015m\u001d5NCB\u0004B!!\u0007\u0002 5\u0011\u00111\u0004\u0006\u0004\u0003;a\u0017\u0001\u00027b]\u001eLA!!\t\u0002\u001c\t9\u0011J\u001c;fO\u0016\u0014\b\u0003BA\u0013\u0003Wi!!a\n\u000b\u0007\u0005%B.\u0001\u0003uS6,\u0017\u0002BA\u0017\u0003O\u0011aAW8oK&#\u0017\u0001\u0003>p]\u0016LEm\u001d\u0011\u0002\u0017i|g.Z(gMN,Go]\u000b\u0003\u0003k\u0001r\u0001^A\n\u0003/\t9\u0004\u0005\u0003\u0002&\u0005e\u0012\u0002BA\u001e\u0003O\u0011!BW8oK>3gm]3u\u00031QxN\\3PM\u001a\u001cX\r^:!\u0003)\u0011X-\u00193IK\u0006$WM\u001d\u000b\u0003\u0003\u0007\u00022ANA#\u0013\r\t9e\u000e\u0002\u0005+:LG/A\u0003qCJ\u001cX\r\u0006\u0002\u0002NA\"\u0011qJA0!\u0019\t\t&a\u0016\u0002\\5\u0011\u00111\u000b\u0006\u0004\u0003+Z\u0016A\u0002<bYV,7/\u0003\u0003\u0002Z\u0005M#!\u0002,bYV,\u0007\u0003BA/\u0003?b\u0001\u0001B\u0006\u0002bI\t\t\u0011!A\u0003\u0002\u0005\r$aA0%cE!\u0011QMA6!\r1\u0014qM\u0005\u0004\u0003S:$a\u0002(pi\"Lgn\u001a\t\u0004m\u00055\u0014bAA8o\t\u0019\u0011I\\=\u0002\u0015I,\u0017\rZ*dQ\u0016l\u0017\r\u0006\u0002\u0002vA!\u0011qOA?\u001b\t\tIHC\u0002\u0002|u\faa]2iK6\f\u0017\u0002BA@\u0003s\u0012aaU2iK6\f\u0017!\u0004:fC\u0012$vn[3o)f\u0004X\r\u0006\u0002\u0002\u0006B\u0019a'a\"\n\u0007\u0005%uGA\u0002J]R\f\u0011B]3bIZ\u000bG.^3\u0015\t\u0005=\u0015\u0011\u0014\u0019\u0005\u0003#\u000b)\n\u0005\u0004\u0002R\u0005]\u00131\u0013\t\u0005\u0003;\n)\nB\u0006\u0002\u0018V\t\t\u0011!A\u0003\u0002\u0005\r$aA0%e!9\u00111T\u000bA\u0002\u0005\u0015\u0015A\u0005;pW\u0016tG+\u001f9f/&$\bN\u00127bON\fqB]3bINCwN\u001d;TiJLgn\u001a\u000b\u0002\u0003\u0006\u0019\"/Z1e\u001d\u0006lW\rR3dY\u0006\u0014\u0018\r^5p]\u0006\t\"/Z1e\u001dN#Um\u00197be\u0006$\u0018n\u001c8\u0015\u0003m\f\u0011B]3bI\u0006\u0013(/Y=\u0015\u0005\u0005-\u0006\u0003BA)\u0003[KA!a,\u0002T\tQ\u0011I\u001d:bsZ\u000bG.^3\u0002\u0015I,\u0017\rZ(cU\u0016\u001cG\u000f\u0006\u0002\u00026B!\u0011\u0011KA\\\u0013\u0011\tI,a\u0015\u0003\u0017=\u0013'.Z2u-\u0006dW/Z\u0001\rO\u0016$\bK]8dKN\u001cxN\u001d\u000b\u0005\u0003\u007f\u000b)\r\u0005\u00037\u0003\u0003\f\u0015bAAbo\t1q\n\u001d;j_:Dq!a\u001f\u001c\u0001\u0004\t)(A\u0005u_.,g\u000eV=qKR!\u0011QQAf\u0011\u001d\tY\n\ba\u0001\u0003\u000b\u000baB]3bI\u0006#HO]5ckR,7\u000f\u0006\u0002\u0002RB1\u0011\u0011KA,\u0003'\u00042\u0001`Ak\u0013\r\t9. \u0002\b\u001d\u0006lWmU3r\u00035\u0011X-\u00193M_\u000e\fGNT1nK\u0006i!/Z1e\u001d\u0006lWm\u001d9bG\u0016\f!B]3bIj{g.Z%e)\t\t\u0019#\u0001\bsK\u0006$'l\u001c8f\u001f\u001a47/\u001a;\u0015\u0005\u0005]\u0002")
public class InMemoryWeaveBinaryParser
implements WeaveBinaryParser {
    private final String name;
    private final SeekableStream inputStream;
    private final EvaluationContext ctx;
    private final DataInputStream input;
    private final ArrayBuffer<Namespace> namespaces;
    private final ArrayBuffer<String> names;
    private final HashMap<Integer, ZoneId> zoneIds;
    private final HashMap<Integer, ZoneOffset> zoneOffsets;
    private final int org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBufferSize;
    private final byte[] org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBuffer;

    @Override
    public void verifyMagicWord(DataInputStream dataInputStream) {
        WeaveBinaryParser.verifyMagicWord$(this, dataInputStream);
    }

    @Override
    public void verifyVersion(DataInputStream dataInputStream) {
        WeaveBinaryParser.verifyVersion$(this, dataInputStream);
    }

    @Override
    public boolean verifyIndexPresence(DataInputStream dataInputStream) {
        return WeaveBinaryParser.verifyIndexPresence$(this, dataInputStream);
    }

    @Override
    public byte[] getReadBuffer() {
        return WeaveBinaryParser.getReadBuffer$(this);
    }

    @Override
    public byte[] getReadBuffer(int length) {
        return WeaveBinaryParser.getReadBuffer$(this, length);
    }

    @Override
    public int org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBufferSize() {
        return this.org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBufferSize;
    }

    @Override
    public byte[] org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBuffer() {
        return this.org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBuffer;
    }

    @Override
    public final void org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$_setter_$org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBufferSize_$eq(int x$1) {
        this.org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBufferSize = x$1;
    }

    @Override
    public final void org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$_setter_$org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBuffer_$eq(byte[] x$1) {
        this.org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBuffer = x$1;
    }

    public String name() {
        return this.name;
    }

    public SeekableStream inputStream() {
        return this.inputStream;
    }

    private DataInputStream input() {
        return this.input;
    }

    private ArrayBuffer<Namespace> namespaces() {
        return this.namespaces;
    }

    private ArrayBuffer<String> names() {
        return this.names;
    }

    private HashMap<Integer, ZoneId> zoneIds() {
        return this.zoneIds;
    }

    private HashMap<Integer, ZoneOffset> zoneOffsets() {
        return this.zoneOffsets;
    }

    public void readHeader() {
        this.verifyMagicWord(this.input());
        this.verifyVersion(this.input());
        this.input().read();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Value<?> parse() {
        void var2_2;
        this.readHeader();
        int nextValueType = this.input().read();
        if (nextValueType == -1) {
            throw new IllegalArgumentException("Input should not be empty");
        }
        Value<?> value = this.readValue(nextValueType);
        return var2_2;
    }

    public Schema readSchema() {
        ArrayBuffer props = new ArrayBuffer();
        int propCount = this.input().readUnsignedShort();
        for (int i = 0; i < propCount; ++i) {
            int nextKeyValueType = this.input().read();
            KeyValue key = (KeyValue)this.readValue(nextKeyValueType);
            StringValue keyStrValue = StringValue$.MODULE$.apply(((QualifiedName)key.evaluate(this.ctx)).name());
            Value<?> value = this.readValue(this.input().read());
            props.$plus$eq((Object)SchemaProperty$.MODULE$.apply((Value)keyStrValue, value));
        }
        return Schema$.MODULE$.apply((Seq)props);
    }

    public int readTokenType() {
        return this.input().read();
    }

    public Value<?> readValue(int tokenTypeWithFlags) {
        LocalDateValue localDateValue;
        int tokenType = DwTokenHelper$.MODULE$.getTokenType(tokenTypeWithFlags);
        boolean hasSchema = DwTokenHelper$.MODULE$.hasSchemaProps(tokenTypeWithFlags);
        int n = tokenType;
        if (DwTokenType$.MODULE$.Key() == n) {
            String name = this.readLocalName();
            QualifiedName qName = new QualifiedName(name, (Option)None$.MODULE$);
            localDateValue = KeyValue$.MODULE$.apply(qName, (Option)None$.MODULE$);
        } else if (DwTokenType$.MODULE$.KeyWithNS() == n) {
            String name = this.readLocalName();
            Namespace namespace = this.readNamespace();
            QualifiedName qName = new QualifiedName(name, (Option)new Some((Object)namespace));
            localDateValue = KeyValue$.MODULE$.apply(qName, (Option)None$.MODULE$);
        } else if (DwTokenType$.MODULE$.KeyWithAttr() == n) {
            String name = this.readLocalName();
            QualifiedName qName = new QualifiedName(name, (Option)None$.MODULE$);
            Value<NameSeq> attrs = this.readAttributes();
            localDateValue = KeyValue$.MODULE$.apply(qName, (Option)new Some(attrs));
        } else if (DwTokenType$.MODULE$.KeyWithNSAttr() == n) {
            String name = this.readLocalName();
            Namespace namespace = this.readNamespace();
            QualifiedName qName = new QualifiedName(name, (Option)new Some((Object)namespace));
            Value<NameSeq> attrs = this.readAttributes();
            localDateValue = KeyValue$.MODULE$.apply(qName, (Option)new Some(attrs));
        } else if (DwTokenType$.MODULE$.String8() == n) {
            StringValue stringValue;
            int length = this.input().read();
            String str = BinaryValueRetriever$.MODULE$.readString(this.input(), length, this.getReadBuffer(length));
            if (hasSchema) {
                Schema schema = this.readSchema();
                stringValue = StringValue$.MODULE$.apply(str, (LocationCapable)UnknownLocationCapable$.MODULE$, (Option)new Some((Object)schema));
            } else {
                stringValue = StringValue$.MODULE$.apply(str);
            }
            localDateValue = stringValue;
        } else if (DwTokenType$.MODULE$.String32() == n) {
            StringValue stringValue;
            int length = this.input().readInt();
            String str = BinaryValueRetriever$.MODULE$.readString(this.input(), length, this.getReadBuffer(length));
            if (hasSchema) {
                Schema schema = this.readSchema();
                stringValue = StringValue$.MODULE$.apply(str, (LocationCapable)UnknownLocationCapable$.MODULE$, (Option)new Some((Object)schema));
            } else {
                stringValue = StringValue$.MODULE$.apply(str);
            }
            localDateValue = stringValue;
        } else if (DwTokenType$.MODULE$.Null() == n) {
            localDateValue = NullValue$.MODULE$;
        } else if (DwTokenType$.MODULE$.True() == n) {
            localDateValue = BooleanValue$.MODULE$.TRUE_BOOL();
        } else if (DwTokenType$.MODULE$.False() == n) {
            localDateValue = BooleanValue$.MODULE$.FALSE_BOOL();
        } else if (DwTokenType$.MODULE$.Int() == n) {
            int number = this.input().readInt();
            localDateValue = NumberValue$.MODULE$.apply(number);
        } else if (DwTokenType$.MODULE$.Long() == n) {
            long number = this.input().readLong();
            localDateValue = NumberValue$.MODULE$.apply(number);
        } else if (DwTokenType$.MODULE$.BigInt() == n) {
            int length = this.input().readUnsignedShort();
            byte[] buffer = new byte[length];
            this.input().readFully(buffer, 0, length);
            localDateValue = NumberValue$.MODULE$.apply(Number$.MODULE$.apply(package$.MODULE$.BigInt().apply(buffer)));
        } else if (DwTokenType$.MODULE$.Double() == n) {
            double number = this.input().readDouble();
            localDateValue = NumberValue$.MODULE$.apply(Number$.MODULE$.apply(number));
        } else if (DwTokenType$.MODULE$.BigDecimal() == n) {
            String str = BinaryValueRetriever$.MODULE$.readShortString(this.input(), this.getReadBuffer());
            localDateValue = NumberValue$.MODULE$.apply(Number$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(str)));
        } else if (DwTokenType$.MODULE$.ObjectStart() == n) {
            localDateValue = this.readObject();
        } else if (DwTokenType$.MODULE$.ArrayStart() == n) {
            localDateValue = this.readArray();
        } else if (DwTokenType$.MODULE$.Binary() == n) {
            int length = this.input().readInt();
            byte[] buffer = new byte[length];
            this.input().readFully(buffer, 0, length);
            localDateValue = BinaryValue$.MODULE$.apply(buffer);
        } else if (DwTokenType$.MODULE$.DeclareNS() == n) {
            this.readNSDeclaration();
            localDateValue = this.readValue(this.readTokenType());
        } else if (DwTokenType$.MODULE$.DeclareName() == n) {
            this.readNameDeclaration();
            localDateValue = this.readValue(this.readTokenType());
        } else if (DwTokenType$.MODULE$.DateTime() == n) {
            long unixTimestamp = this.input().readLong();
            int nanos = this.input().readInt();
            Instant instant = Instant.ofEpochSecond(unixTimestamp, nanos);
            ZoneId zoneId = this.readZoneId();
            ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, zoneId);
            localDateValue = DateTimeValue$.MODULE$.apply(zonedDateTime);
        } else if (DwTokenType$.MODULE$.LocalDateTime() == n) {
            long unixTimestamp = this.input().readLong();
            int nanos = this.input().readInt();
            localDateValue = LocalDateTimeValue$.MODULE$.apply(LocalDateTime.ofEpochSecond(unixTimestamp, nanos, ZoneOffset.UTC));
        } else if (DwTokenType$.MODULE$.LocalDate() == n) {
            long epochDay = this.input().readLong();
            localDateValue = LocalDateValue$.MODULE$.apply(LocalDate.ofEpochDay(epochDay));
        } else if (DwTokenType$.MODULE$.Time() == n) {
            long nanoOfDay = this.input().readLong();
            LocalTime localTime = LocalTime.ofNanoOfDay(nanoOfDay);
            ZoneOffset zoneOffset = this.readZoneOffset();
            OffsetTime offsetTime = OffsetTime.of(localTime, zoneOffset);
            localDateValue = TimeValue$.MODULE$.apply(offsetTime);
        } else if (DwTokenType$.MODULE$.LocalTime() == n) {
            long nanoOfDay = this.input().readLong();
            LocalTime localTime = LocalTime.ofNanoOfDay(nanoOfDay);
            localDateValue = LocalTimeValue$.MODULE$.apply(localTime);
        } else if (DwTokenType$.MODULE$.TimeZone() == n) {
            ZoneId zoneId = this.readZoneId();
            localDateValue = TimeZoneValue$.MODULE$.apply(zoneId);
        } else if (DwTokenType$.MODULE$.Period() == n) {
            String str = this.input().readUTF();
            localDateValue = PeriodValue$.MODULE$.apply(str, (LocationCapable)UnknownLocationCapable$.MODULE$);
        } else if (DwTokenType$.MODULE$.Regex() == n) {
            String str = this.input().readUTF();
            localDateValue = RegexValue$.MODULE$.apply(str);
        } else if (DwTokenType$.MODULE$.Range() == n) {
            int start = this.input().readInt();
            int end = this.input().readInt();
            localDateValue = RangeValue$.MODULE$.apply(start, end, (LocationCapable)UnknownLocationCapable$.MODULE$);
        } else {
            throw new DWBRuntimeExecutionException(new StringBuilder(24).append("Unexpected value type '").append(DwTokenType$.MODULE$.getNameFor(n)).append("'").toString(), DWBRuntimeExecutionException$.MODULE$.$lessinit$greater$default$2());
        }
        LocalDateValue value = localDateValue;
        return value;
    }

    private String readShortString() {
        return BinaryValueRetriever$.MODULE$.readShortString(this.input(), this.getReadBuffer());
    }

    /*
     * WARNING - void declaration
     */
    public String readNameDeclaration() {
        void var1_1;
        String name = this.readShortString();
        this.names().$plus$eq((Object)name);
        return var1_1;
    }

    public Namespace readNSDeclaration() {
        String str = this.readShortString();
        Tuple2 tuple2 = new StringOps(Predef$.MODULE$.augmentString(str)).splitAt(str.indexOf(":"));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String prefix = (String)tuple2._1();
        String uri = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)prefix, (Object)uri);
        Tuple2 tuple23 = tuple22;
        String prefix2 = (String)tuple23._1();
        String uri2 = (String)tuple23._2();
        Namespace ns = new Namespace(prefix2, uri2.substring(1));
        this.namespaces().$plus$eq((Object)ns);
        return ns;
    }

    private ArrayValue readArray() {
        ArrayBuffer values = new ArrayBuffer();
        int nextValueType = this.readTokenType();
        while (nextValueType != DwTokenType$.MODULE$.StructureEnd()) {
            Value<?> value = this.readValue(nextValueType);
            values.$plus$eq(value);
            nextValueType = this.readTokenType();
        }
        return new InMemoryJsonArray(ArraySeq$.MODULE$.apply(values, true), (Location)UnknownLocation$.MODULE$);
    }

    private ObjectValue readObject() {
        MaterializedObjectValue materializedObjectValue;
        ArrayBuffer kvps = new ArrayBuffer();
        int tokenTypeWithFlags = this.readTokenType();
        while (this.tokenType(tokenTypeWithFlags) != DwTokenType$.MODULE$.StructureEnd()) {
            KeyValue key = (KeyValue)this.readValue(tokenTypeWithFlags);
            Value<?> value = this.readValue(this.readTokenType());
            kvps.$plus$eq((Object)new KeyValuePair((Value)key, value, KeyValuePair$.MODULE$.apply$default$3()));
            tokenTypeWithFlags = this.readTokenType();
        }
        ObjectSeq objectSeq = ObjectSeq$.MODULE$.apply(kvps, true);
        boolean objectHasSchema = DwTokenHelper$.MODULE$.hasSchemaProps(tokenTypeWithFlags);
        if (objectHasSchema) {
            MaterializedObjectValue materializedObjectValue2;
            Schema schema = this.readSchema();
            Option<String> option = this.getProcessor(schema);
            if (option instanceof Some) {
                Some some = (Some)option;
                String processor = (String)some.value();
                Map<String, IWeaveValue<?>> schemaMap = WeaveValue$.MODULE$.toWeaveValueMap(schema, this.ctx);
                RedefinedObjectSeq redefinedObjectSeq = new RedefinedObjectSeq(objectSeq, processor, schemaMap, (LocationCapable)UnknownLocationCapable$.MODULE$, this.ctx);
                materializedObjectValue2 = new MaterializedObjectValue((ObjectSeq)redefinedObjectSeq, (LocationCapable)UnknownLocationCapable$.MODULE$, (Option)new Some((Object)schema));
            } else if (None$.MODULE$.equals(option)) {
                materializedObjectValue2 = new MaterializedObjectValue(objectSeq, (LocationCapable)UnknownLocationCapable$.MODULE$, (Option)new Some((Object)schema));
            } else {
                throw new MatchError(option);
            }
            materializedObjectValue = materializedObjectValue2;
        } else {
            materializedObjectValue = new MaterializedObjectValue(objectSeq, (LocationCapable)UnknownLocationCapable$.MODULE$, MaterializedObjectValue$.MODULE$.$lessinit$greater$default$3());
        }
        return materializedObjectValue;
    }

    private Option<String> getProcessor(Schema schema) {
        return schema.valueOf("processor", this.ctx).map((Function1 & Serializable & scala.Serializable)processor -> StringType$.MODULE$.coerce(processor, $this.ctx).evaluate($this.ctx).toString());
    }

    private int tokenType(int tokenTypeWithFlags) {
        return tokenTypeWithFlags & DwTokenHelper$.MODULE$.TOKEN_TYPE_MASK();
    }

    private Value<NameSeq> readAttributes() {
        ArrayBuffer attrPairs = new ArrayBuffer();
        int attrCount = this.input().readUnsignedShort();
        for (int i = 0; i < attrCount; ++i) {
            int nextValueType = this.readTokenType();
            KeyValue qName = (KeyValue)this.readValue(nextValueType);
            Value<?> value = this.readValue(this.readTokenType());
            attrPairs.$plus$eq((Object)new NameValuePair((Value)qName, value));
        }
        return AttributesValue$.MODULE$.apply((Seq)attrPairs);
    }

    public String readLocalName() {
        int nameIndex = this.input().readUnsignedShort();
        return (String)this.names().apply(nameIndex);
    }

    /*
     * WARNING - void declaration
     */
    private Namespace readNamespace() {
        void var2_2;
        int nsIndex = this.input().readUnsignedShort();
        Namespace namespace = (Namespace)this.namespaces().apply(nsIndex);
        return var2_2;
    }

    private ZoneId readZoneId() {
        ZoneId zoneId;
        int nameIndex = this.input().readUnsignedShort();
        Option zoneIdMaybe = this.zoneIds().get((Object)Predef$.MODULE$.int2Integer(nameIndex));
        Option option = zoneIdMaybe;
        if (option instanceof Some) {
            ZoneId zoneId2;
            Some some = (Some)option;
            zoneId = zoneId2 = (ZoneId)some.value();
        } else if (None$.MODULE$.equals(option)) {
            String nameStr = (String)this.names().apply(nameIndex);
            ZoneId zoneId3 = ZoneId.of(nameStr);
            this.zoneIds().put((Object)Predef$.MODULE$.int2Integer(nameIndex), (Object)zoneId3);
            zoneId = zoneId3;
        } else {
            throw new MatchError((Object)option);
        }
        return zoneId;
    }

    private ZoneOffset readZoneOffset() {
        ZoneOffset zoneOffset;
        int nameIndex = this.input().readUnsignedShort();
        Option zoneOffsetMaybe = this.zoneOffsets().get((Object)Predef$.MODULE$.int2Integer(nameIndex));
        Option option = zoneOffsetMaybe;
        if (option instanceof Some) {
            ZoneOffset zoneId;
            Some some = (Some)option;
            zoneOffset = zoneId = (ZoneOffset)some.value();
        } else if (None$.MODULE$.equals(option)) {
            String nameStr = (String)this.names().apply(nameIndex);
            ZoneOffset zoneOffset2 = ZoneOffset.of(nameStr);
            this.zoneOffsets().put((Object)Predef$.MODULE$.int2Integer(nameIndex), (Object)zoneOffset2);
            zoneOffset = zoneOffset2;
        } else {
            throw new MatchError((Object)option);
        }
        return zoneOffset;
    }

    public InMemoryWeaveBinaryParser(String name, SeekableStream inputStream, EvaluationContext ctx) {
        this.name = name;
        this.inputStream = inputStream;
        this.ctx = ctx;
        WeaveBinaryParser.$init$(this);
        this.input = new DataInputStream(new BufferedInputStream((InputStream)inputStream));
        this.namespaces = new ArrayBuffer(0);
        this.names = new ArrayBuffer();
        this.zoneIds = new HashMap();
        this.zoneOffsets = new HashMap();
    }
}

