/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.dwb.reader.indexed;

import java.io.DataInputStream;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.schema.Schema;
import org.mule.weave.v2.model.types.Type;
import org.mule.weave.v2.model.values.DateTimeValue;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.model.values.math.Number;
import org.mule.weave.v2.module.dwb.BinaryLocation;
import org.mule.weave.v2.module.dwb.DwTokenHelper$;
import org.mule.weave.v2.module.dwb.reader.indexed.BinaryParserInput;
import org.mule.weave.v2.parser.location.Location;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001m3A\u0001C\u0005\u00015!A\u0011\u0006\u0001B\u0001B\u0003%!\u0006\u0003\u00051\u0001\t\u0005\t\u0015!\u00032\u0011\u0015)\u0004\u0001\"\u00017\u0011!Q\u0004\u0001#b\u0001\n\u0013Y\u0004\u0002\u0003\u001f\u0001\u0011\u000b\u0007I\u0011B\u001f\t\u000b\u0019\u0003A\u0011I$\t\u000bI\u0003A\u0011I*\u0003']+\u0017M^3CS:\f'/\u001f#bi\u0016$\u0016.\\3\u000b\u0005)Y\u0011aB5oI\u0016DX\r\u001a\u0006\u0003\u00195\taA]3bI\u0016\u0014(B\u0001\b\u0010\u0003\r!wO\u0019\u0006\u0003!E\ta!\\8ek2,'B\u0001\n\u0014\u0003\t1(G\u0003\u0002\u0015+\u0005)q/Z1wK*\u0011acF\u0001\u0005[VdWMC\u0001\u0019\u0003\ry'oZ\u0002\u0001'\r\u00011$\t\t\u00039}i\u0011!\b\u0006\u0002=\u0005)1oY1mC&\u0011\u0001%\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\t:S\"A\u0012\u000b\u0005\u0011*\u0013A\u0002<bYV,7O\u0003\u0002'#\u0005)Qn\u001c3fY&\u0011\u0001f\t\u0002\u000e\t\u0006$X\rV5nKZ\u000bG.^3\u0002\u000bQ|7.\u001a8\u0011\u0007qYS&\u0003\u0002-;\t)\u0011I\u001d:bsB\u0011ADL\u0005\u0003_u\u0011A\u0001T8oO\u0006)\u0011N\u001c9viB\u0011!gM\u0007\u0002\u0013%\u0011A'\u0003\u0002\u0012\u0005&t\u0017M]=QCJ\u001cXM]%oaV$\u0018A\u0002\u001fj]&$h\bF\u00028qe\u0002\"A\r\u0001\t\u000b%\u001a\u0001\u0019\u0001\u0016\t\u000bA\u001a\u0001\u0019A\u0019\u0002\r=4gm]3u+\u0005i\u0013!\u0002<bYV,W#\u0001 \u0011\u0005}\"U\"\u0001!\u000b\u0005\u0005\u0013\u0015\u0001\u0002;j[\u0016T\u0011aQ\u0001\u0005U\u00064\u0018-\u0003\u0002F\u0001\ni!l\u001c8fI\u0012\u000bG/\u001a+j[\u0016\f\u0001\"\u001a<bYV\fG/\u001a\u000b\u0003\u00112\u0003\"!\u0013&\u000e\u0003\u0001I!aS\u0014\u0003\u0003QCQ!\u0014\u0004A\u00049\u000b1a\u0019;y!\ty\u0005+D\u0001&\u0013\t\tVEA\tFm\u0006dW/\u0019;j_:\u001cuN\u001c;fqR\f\u0001\u0002\\8dCRLwN\u001c\u000b\u0002)B\u0011Q+W\u0007\u0002-*\u0011!k\u0016\u0006\u00031F\ta\u0001]1sg\u0016\u0014\u0018B\u0001.W\u0005!aunY1uS>t\u0007")
public class WeaveBinaryDateTime
implements DateTimeValue {
    private long offset;
    private ZonedDateTime value;
    private long[] token;
    private final BinaryParserInput input;
    private volatile byte bitmap$0;

    public final Type valueType(EvaluationContext ctx) {
        return DateTimeValue.valueType$((DateTimeValue)this, (EvaluationContext)ctx);
    }

    public Number compareTo(Value<?> compareTo, EvaluationContext ctx) {
        return DateTimeValue.compareTo$((DateTimeValue)this, compareTo, (EvaluationContext)ctx);
    }

    public boolean equals(Value<?> value, EvaluationContext ctx) {
        return DateTimeValue.equals$((DateTimeValue)this, value, (EvaluationContext)ctx);
    }

    public int hashCode(EvaluationContext ctx) {
        return DateTimeValue.hashCode$((DateTimeValue)this, (EvaluationContext)ctx);
    }

    public Value<ZonedDateTime> materialize(EvaluationContext ctx) {
        return Value.materialize$((Value)this, (EvaluationContext)ctx);
    }

    public boolean isSimilarTo(Value<?> value, EvaluationContext ctx) {
        return Value.isSimilarTo$((Value)this, value, (EvaluationContext)ctx);
    }

    public boolean isSimilarValue(Value<? super ZonedDateTime> thatValue, EvaluationContext ctx) {
        return Value.isSimilarValue$((Value)this, thatValue, (EvaluationContext)ctx);
    }

    public Option<Schema> schema(EvaluationContext ctx) {
        return Value.schema$((Value)this, (EvaluationContext)ctx);
    }

    private long offset$lzycompute() {
        WeaveBinaryDateTime weaveBinaryDateTime = this;
        synchronized (weaveBinaryDateTime) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.offset = DwTokenHelper$.MODULE$.getOffset(this.token);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        this.token = null;
        return this.offset;
    }

    private long offset() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.offset$lzycompute() : this.offset;
    }

    private ZonedDateTime value$lzycompute() {
        WeaveBinaryDateTime weaveBinaryDateTime = this;
        synchronized (weaveBinaryDateTime) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                DataInputStream stream = this.input.dataInputStream();
                this.input.seekableStream().seek(this.offset());
                long unixTimestamp = stream.readLong();
                int nanos = stream.readInt();
                int zoneIndex = stream.readUnsignedShort();
                Instant instant = Instant.ofEpochSecond(unixTimestamp, nanos);
                ZoneId zoneId = this.input.zoneIds().get(zoneIndex);
                this.value = ZonedDateTime.ofInstant(instant, zoneId);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.value;
    }

    private ZonedDateTime value() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.value$lzycompute() : this.value;
    }

    public ZonedDateTime evaluate(EvaluationContext ctx) {
        return this.value();
    }

    public Location location() {
        return new BinaryLocation(this.offset());
    }

    public WeaveBinaryDateTime(long[] token, BinaryParserInput input) {
        this.token = token;
        this.input = input;
        Value.$init$((Value)this);
        DateTimeValue.$init$((DateTimeValue)this);
    }
}

