package org.mule.weave.v2.module.dwb.reader

import java.util

import org.mule.weave.v2.dwb.api.IWeaveValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.ArraySeq
import org.mule.weave.v2.model.values.Value

class SimpleArraySeqList(seq: ArraySeq)(implicit ctx: EvaluationContext) extends util.AbstractList[IWeaveValue[_]] {
  override def size(): Int = seq.size().toInt

  override def iterator(): util.Iterator[IWeaveValue[_]] = {
    val it: Iterator[Value[_]] = seq.toIterator()
    new EntryIterator(it)
  }

  override def isEmpty: Boolean = seq.isEmpty()

  override def get(index: Int): IWeaveValue[_] = {
    val value = seq.apply(index).get
    WeaveValue(value)
  }

  class EntryIterator(it: Iterator[Value[_]]) extends util.Iterator[IWeaveValue[_]] {
    override def hasNext: Boolean = it.hasNext

    override def next(): IWeaveValue[_] = {
      WeaveValue(it.next())
    }
  }

}
