package org.mule.weave.v2.module.avro.exception

import org.apache.avro.Schema
import org.mule.weave.v2.model.types.Type
import org.mule.weave.v2.parser.location.Location
import org.mule.weave.v2.utils.StringHelper

class InvalidValueForUnionException(reasons: Seq[Throwable], val location: Location, types: Seq[Schema.Type], valueType: Type) extends AvroInvalidTypeException {
  override def message: String = s"Unable to write `${valueType}` as Union of (${types.mkString(" or ")}).\nReasons (${reasons.size}):\n ${reasons.map((r) => "- " + String.valueOf(r.getMessage).trim).map(StringHelper.indent).mkString("\n")}"
}
