package org.mule.weave.v2.module.avro

import org.apache.avro.generic.GenericData
import org.mule.weave.v2.grammar.literals.TypeLiteral
import org.mule.weave.v2.model.values.StringValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.module.pojo.reader.JavaValueMapper
import org.mule.weave.v2.parser.ast.types.TypeReferenceNode
import org.mule.weave.v2.parser.ast.types.WeaveTypeNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.parser.location.DefaultLocationCapable
import org.mule.weave.v2.parser.location.SimpleLocation

class AvroEnumSymbolJavaValueMapper extends JavaValueMapper {

  override def javaType: Class[_] = classOf[GenericData.EnumSymbol]

  override def map(value: Any, loc: () => String): Value[_] = {
    val es = value.asInstanceOf[GenericData.EnumSymbol]
    StringValue(es.toString, DefaultLocationCapable(SimpleLocation(loc())))
  }

  override def typeNode(value: Class[_]): WeaveTypeNode = TypeReferenceNode(NameIdentifier(TypeLiteral.STRING_TYPE_NAME), None)
}
