/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.validation;

import org.mule.tools.client.core.exception.DeploymentException;
import org.mule.tools.model.Deployment;
import org.mule.tools.validation.EnvironmentSupportedVersions;

public abstract class AbstractDeploymentValidator {
    protected final Deployment deployment;

    public AbstractDeploymentValidator(Deployment deployment) {
        this.deployment = deployment;
    }

    public void validateMuleVersionAgainstEnvironment() throws DeploymentException {
        String deploymentMuleVersion = this.deployment.getMuleVersion();
        if (deploymentMuleVersion == null) {
            throw new DeploymentException("muleVersion is not present in deployment configuration");
        }
        EnvironmentSupportedVersions environmentVersion = this.getEnvironmentSupportedVersions();
        environmentVersion.supports(deploymentMuleVersion);
    }

    public abstract EnvironmentSupportedVersions getEnvironmentSupportedVersions() throws DeploymentException;
}

