/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.client.standalone.installer;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.eclipse.aether.deployment.DeploymentException;
import org.mule.tools.artifact.ArtifactCoordinates;
import org.mule.tools.model.standalone.ClusterDeployment;
import org.mule.tools.utils.DeployerLog;

public class MuleStandaloneInstaller {
    private ClusterDeployment clusterDeployment;
    private MavenProject mavenProject;
    private ArtifactResolver artifactResolver;
    private ArchiverManager archiverManager;
    private ArtifactFactory artifactFactory;
    private DeployerLog log;
    private ArtifactRepository localRepository;

    public MuleStandaloneInstaller(ClusterDeployment clusterDeployment, MavenProject mavenProject, ArtifactResolver artifactResolver, ArchiverManager archiverManager, ArtifactFactory artifactFactory, ArtifactRepository localRepository, DeployerLog log) {
        this.clusterDeployment = clusterDeployment;
        this.mavenProject = mavenProject;
        this.artifactResolver = artifactResolver;
        this.archiverManager = archiverManager;
        this.artifactFactory = artifactFactory;
        this.localRepository = localRepository;
        this.log = log;
    }

    public File installMule(File buildDirectory) throws DeploymentException {
        if (this.clusterDeployment.getMuleHome() == null) {
            this.clusterDeployment.setMuleHome(this.doInstallMule(buildDirectory));
        }
        this.mavenProject.getProperties().setProperty("mule.home", this.clusterDeployment.getMuleHome().getAbsolutePath());
        this.log.info("Using MULE_HOME: " + this.clusterDeployment.getMuleHome());
        return this.clusterDeployment.getMuleHome();
    }

    public File doInstallMule(File buildDirectory) throws DeploymentException {
        if (this.clusterDeployment.getMuleDistribution() == null) {
            this.clusterDeployment.setMuleDistribution(new ArtifactCoordinates("org.mule.distributions", "mule-standalone", this.clusterDeployment.getMuleVersion(), "tar.gz", ""));
            this.log.debug("muleDistribution not set, using default community artifact: " + this.clusterDeployment.getMuleDistribution());
        }
        this.unpackMule(this.clusterDeployment.getMuleDistribution(), buildDirectory);
        String contentDirectory = this.resolveMuleContentDirectory(this.clusterDeployment.getMuleDistribution());
        return new File(buildDirectory, contentDirectory);
    }

    private String resolveMuleContentDirectory(ArtifactCoordinates muleDistribution) {
        return "mule-" + ("mule-standalone".equals(muleDistribution.getArtifactId()) ? "" : "enterprise-") + "standalone-" + muleDistribution.getVersion();
    }

    public void unpackMule(ArtifactCoordinates muleDistribution, File destDir) throws DeploymentException {
        File src = this.getDependency(muleDistribution);
        this.log.info("Copying " + src.getAbsolutePath() + " to " + destDir.getAbsolutePath());
        this.extract(src, destDir, muleDistribution.getType());
    }

    private void extract(File src, File dest, String type) throws DeploymentException {
        try {
            UnArchiver unArchiver = this.getArchiver(type);
            unArchiver.setSourceFile(src);
            unArchiver.setDestDirectory(dest);
            unArchiver.extract();
        }
        catch (ArchiverException e) {
            throw new DeploymentException("Couldn't extract file " + src + " to " + dest);
        }
    }

    private UnArchiver getArchiver(String type) throws DeploymentException {
        try {
            UnArchiver unArchiver = this.archiverManager.getUnArchiver(type);
            this.log.debug("Found unArchiver by extension: " + unArchiver);
            return unArchiver;
        }
        catch (NoSuchArchiverException e) {
            throw new DeploymentException("Couldn't find archiver for type: " + type);
        }
    }

    protected File getDependency(ArtifactCoordinates artifactDescription) throws DeploymentException {
        try {
            Artifact artifact = this.artifactFactory.createArtifact(artifactDescription.getGroupId(), artifactDescription.getArtifactId(), artifactDescription.getVersion(), null, artifactDescription.getType());
            this.log.info("Resolving " + artifact);
            this.artifactResolver.resolve(artifact, this.mavenProject.getRemoteArtifactRepositories(), this.localRepository);
            return artifact.getFile();
        }
        catch (AbstractArtifactResolutionException e) {
            throw new DeploymentException("Fail download artifact: " + artifactDescription.toString(), (Throwable)e);
        }
    }
}

