/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.client.fabric;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.ws.rs.core.Response;
import org.mule.tools.client.AbstractMuleClient;
import org.mule.tools.client.fabric.model.DeploymentDetailedResponse;
import org.mule.tools.client.fabric.model.DeploymentModify;
import org.mule.tools.client.fabric.model.DeploymentRequest;
import org.mule.tools.client.fabric.model.Deployments;
import org.mule.tools.model.anypoint.RuntimeFabricDeployment;
import org.mule.tools.utils.DeployerLog;

public class RuntimeFabricClient
extends AbstractMuleClient {
    public static final String API_VERSION = "/v2";
    public static final String BASE_HYBRID_API_PATH = "/hybrid/api";
    public static final String HYBRID_API = "/hybrid/api/v2";
    public static final String RESOURCES_PATH = "/hybrid/api/v2/organizations/%s/environments/%s";
    public static final String DEPLOYMENTS_PATH = "/hybrid/api/v2/organizations/%s/environments/%s/deployments";
    public static final String WORKERCLOUD_API_V1_AGENTS = "workercloud/api/organizations/%s/agents";
    public static final String RUNTIME_FABRIC_TARGET_INFO = "runtimefabric/api/organizations/%s/targets/%s";

    public RuntimeFabricClient(RuntimeFabricDeployment runtimeFabricDeployment, DeployerLog log) {
        super(runtimeFabricDeployment, log);
    }

    public Deployments getDeployments() {
        Response response = this.get(this.baseUri, this.getPath());
        this.checkResponseStatus(response, Response.Status.OK);
        return (Deployments)response.readEntity(Deployments.class);
    }

    public DeploymentDetailedResponse deploy(DeploymentRequest request) {
        this.log.info("Deploying " + request.name);
        Response response = this.post(this.baseUri, this.getPath(), new Gson().toJson((Object)request));
        this.checkResponseStatus(response, Response.Status.ACCEPTED);
        return (DeploymentDetailedResponse)response.readEntity(DeploymentDetailedResponse.class);
    }

    public DeploymentDetailedResponse redeploy(DeploymentModify modify, String deploymentId) {
        this.log.info("Redeploying...");
        Response response = this.patch(this.baseUri, this.getDeploymentPath(deploymentId), new Gson().toJson((Object)modify));
        this.checkResponseStatus(response, Response.Status.OK);
        return (DeploymentDetailedResponse)response.readEntity(DeploymentDetailedResponse.class);
    }

    public DeploymentDetailedResponse getDeployment(String deploymentId) {
        Response response = this.get(this.baseUri, this.getDeploymentPath(deploymentId));
        this.checkResponseStatus(response, Response.Status.OK);
        return (DeploymentDetailedResponse)response.readEntity(DeploymentDetailedResponse.class);
    }

    public DeploymentDetailedResponse deleteDeployment(String deploymentId) {
        Response response = this.delete(this.baseUri, this.getDeploymentPath(deploymentId));
        this.checkResponseStatus(response, Response.Status.NO_CONTENT);
        return (DeploymentDetailedResponse)response.readEntity(DeploymentDetailedResponse.class);
    }

    private String getDeploymentPath(String deploymentId) {
        return String.format(this.getPath() + "/%s", deploymentId);
    }

    public String getPath() {
        this.initialize();
        return String.format(DEPLOYMENTS_PATH, this.getOrgId(), this.getEnvId());
    }

    public String getAgentsPath() {
        this.initialize();
        return String.format(WORKERCLOUD_API_V1_AGENTS, this.getOrgId());
    }

    public JsonArray getTargets() {
        Response response = this.get(this.baseUri, this.getAgentsPath());
        this.checkResponseStatus(response, Response.Status.OK);
        return ((JsonElement)new Gson().fromJson((String)response.readEntity(String.class), JsonElement.class)).getAsJsonArray();
    }

    public JsonObject getTargetInfo(String targetId) {
        Response response = this.get(this.baseUri, String.format(RUNTIME_FABRIC_TARGET_INFO, this.getOrgId(), targetId));
        this.checkResponseStatus(response, Response.Status.OK);
        return ((JsonElement)new Gson().fromJson((String)response.readEntity(String.class), JsonElement.class)).getAsJsonObject();
    }
}

