/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.client.arm;

import com.google.gson.GsonBuilder;
import java.io.File;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;
import org.mule.tools.client.AbstractMuleClient;
import org.mule.tools.client.arm.ApplicationMetadata;
import org.mule.tools.client.arm.model.Application;
import org.mule.tools.client.arm.model.Applications;
import org.mule.tools.client.arm.model.Data;
import org.mule.tools.client.arm.model.RegistrationToken;
import org.mule.tools.client.arm.model.Servers;
import org.mule.tools.client.arm.model.Target;
import org.mule.tools.client.arm.model.Targets;
import org.mule.tools.client.model.TargetType;
import org.mule.tools.model.Deployment;
import org.mule.tools.model.anypoint.AnypointDeployment;
import org.mule.tools.model.anypoint.ArmDeployment;
import org.mule.tools.utils.DeployerLog;

public class ArmClient
extends AbstractMuleClient {
    public static final String HYBRID_API_V1 = "/hybrid/api/v1";
    private static final String CLUSTERS = "/hybrid/api/v1/clusters";
    private static final String APPLICATIONS = "/hybrid/api/v1/applications";
    private static final String SERVER_GROUPS = "/hybrid/api/v1/serverGroups";
    private static final String SERVERS = "/hybrid/api/v1/servers";
    private static final String REGISTRATION = "/hybrid/api/v1/servers/registrationToken";
    private boolean armInsecure;

    public ArmClient(Deployment armDeployment, DeployerLog log) {
        super((AnypointDeployment)armDeployment, log);
        this.armInsecure = ((ArmDeployment)armDeployment).isArmInsecure();
        if (this.armInsecure) {
            log.warn("Using insecure mode for connecting to ARM, please consider configuring your truststore with ARM certificates. This option is insecure and not intended for production use.");
        }
    }

    public String getRegistrationToken() {
        RegistrationToken registrationToken = this.get(this.baseUri, REGISTRATION, RegistrationToken.class);
        return registrationToken.data;
    }

    public Boolean isStarted(int applicationId) {
        Application application = this.getApplication(applicationId);
        return "STARTED".equals(application.data.lastReportedStatus);
    }

    public Application getApplication(int applicationId) {
        return this.get(this.baseUri, "/hybrid/api/v1/applications/" + applicationId, Application.class);
    }

    public String undeployApplication(int applicationId) {
        Response response = this.delete(this.baseUri, "/hybrid/api/v1/applications/" + applicationId);
        this.checkResponseStatus(response);
        return (String)response.readEntity(String.class);
    }

    public String undeployApplication(ApplicationMetadata applicationMetadata) {
        Integer applicationId = this.findApplicationId(applicationMetadata);
        if (applicationId == null) {
            throw new NotFoundException("The " + applicationMetadata.toString() + "does not exist.");
        }
        return this.undeployApplication(applicationId);
    }

    public Application deployApplication(ApplicationMetadata applicationMetadata) {
        MultiPart body = this.buildRequestBody(applicationMetadata);
        Response response = this.post(this.baseUri, APPLICATIONS, Entity.entity((Object)body, (MediaType)body.getMediaType()));
        this.checkResponseStatus(response);
        return (Application)response.readEntity(Application.class);
    }

    public Application redeployApplication(int applicationId, ApplicationMetadata applicationMetadata) {
        MultiPart body = this.buildRequestBody(applicationMetadata);
        Response response = this.patch(this.baseUri, "/hybrid/api/v1/applications/" + applicationId, Entity.entity((Object)body, (MediaType)body.getMediaType()));
        this.checkResponseStatus(response);
        return (Application)response.readEntity(Application.class);
    }

    private MultiPart buildRequestBody(ApplicationMetadata metadata) {
        return this.buildRequestBody(metadata.getFile(), metadata.getName(), metadata.getTargetType(), metadata.getTarget(), metadata.getProperties());
    }

    protected MultiPart buildRequestBody(File app, String appName, TargetType targetType, String target, Map<String, String> propertiesMap) {
        String id = this.getId(targetType, target);
        FileDataBodyPart applicationPart = this.createApplicationPart(app);
        FormDataMultiPart formDataMultiPart = new FormDataMultiPart().field("artifactName", appName).field("targetId", id);
        if (propertiesMap != null) {
            HashMap applicationPropertiesService = new HashMap();
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("properties", propertiesMap);
            properties.put("applicationName", appName);
            applicationPropertiesService.put("mule.agent.application.properties.service", properties);
            formDataMultiPart.field("configuration", new GsonBuilder().setPrettyPrinting().create().toJson(applicationPropertiesService));
        }
        return formDataMultiPart.bodyPart((BodyPart)applicationPart);
    }

    protected FileDataBodyPart createApplicationPart(File app) {
        return new FileDataBodyPart("file", app);
    }

    public String getId(TargetType targetType, String target) {
        String id = null;
        switch (targetType) {
            case server: {
                id = this.findServerByName((String)target).id;
                break;
            }
            case serverGroup: {
                id = this.findServerGroupByName((String)target).id;
                break;
            }
            case cluster: {
                id = this.findClusterByName((String)target).id;
            }
        }
        return id;
    }

    public Applications getApplications() {
        return this.get(this.baseUri, APPLICATIONS, Applications.class);
    }

    public List<Target> getServers() {
        Targets targets = this.get(this.baseUri, SERVERS, Targets.class);
        return Arrays.asList(targets.data);
    }

    public Servers getServer(Integer serverId) {
        Servers target = this.get(this.baseUri, "/hybrid/api/v1/servers/" + serverId, Servers.class);
        return target;
    }

    public void deleteServer(Integer serverId) {
        Response response = this.delete(this.baseUri, "/hybrid/api/v1/servers/" + serverId);
        this.checkResponseStatus(response);
    }

    public Target findServerByName(String name) {
        return this.findTargetByName(name, SERVERS);
    }

    public Target findServerGroupByName(String name) {
        return this.findTargetByName(name, SERVER_GROUPS);
    }

    public Target findClusterByName(String name) {
        return this.findTargetByName(name, CLUSTERS);
    }

    private Target findTargetByName(String name, String path) {
        Targets response = this.get(this.baseUri, path, Targets.class);
        if (response.data == null) {
            throw new RuntimeException("Couldn't find target named [" + name + "]");
        }
        for (int i = 0; i < response.data.length; ++i) {
            if (!name.equals(response.data[i].name)) continue;
            return response.data[i];
        }
        throw new RuntimeException("Couldn't find target named [" + name + "]");
    }

    public Integer findApplicationId(ApplicationMetadata applicationMetadata) {
        Applications apps = this.getApplications();
        Data[] appArray = this.getApplications().data;
        if (appArray == null) {
            return null;
        }
        String targetId = this.getId(applicationMetadata.getTargetType(), applicationMetadata.getTarget());
        for (int i = 0; i < appArray.length; ++i) {
            if (!applicationMetadata.getName().equals(appArray[i].artifact.name) || !targetId.equals(appArray[i].target.id)) continue;
            return appArray[i].id;
        }
        return null;
    }

    @Override
    protected void configureSecurityContext(ClientBuilder builder) {
        if (this.armInsecure) {
            try {
                SSLContext sslcontext = SSLContext.getInstance("TLS");
                sslcontext.init(null, new TrustManager[]{new TrustAllManager()}, new SecureRandom());
                builder.hostnameVerifier((HostnameVerifier)new DummyHostnameVerifier()).sslContext(sslcontext);
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class TrustAllManager
    implements X509TrustManager {
        private TrustAllManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    private static class DummyHostnameVerifier
    implements HostnameVerifier {
        private DummyHostnameVerifier() {
        }

        @Override
        public boolean verify(String s, SSLSession sslSession) {
            return true;
        }
    }
}

