/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.classloader;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.mule.tools.api.classloader.AppClassLoaderModelJsonSerializer;
import org.mule.tools.api.classloader.ArtifactCustomJsonSerializer;
import org.mule.tools.api.classloader.model.AppClassLoaderModel;
import org.mule.tools.api.classloader.model.Artifact;
import org.mule.tools.api.classloader.model.ClassLoaderModel;

public class ClassLoaderModelJsonSerializer {
    public static ClassLoaderModel deserialize(File classLoaderModelDescriptor) {
        try {
            Gson gson = new GsonBuilder().enableComplexMapKeySerialization().setPrettyPrinting().create();
            FileReader reader = new FileReader(classLoaderModelDescriptor);
            ClassLoaderModel classLoaderModel = (ClassLoaderModel)gson.fromJson((Reader)reader, ClassLoaderModel.class);
            ((Reader)reader).close();
            return classLoaderModel;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create classloader-model.json", e);
        }
    }

    public static String serialize(ClassLoaderModel classLoaderModel) {
        Gson gson = new GsonBuilder().enableComplexMapKeySerialization().setPrettyPrinting().registerTypeAdapter(Artifact.class, (Object)new ArtifactCustomJsonSerializer()).registerTypeAdapter(AppClassLoaderModel.class, (Object)new AppClassLoaderModelJsonSerializer.AppClassLoaderModelCustomJsonSerializer()).create();
        ClassLoaderModel parameterizedClassloaderModel = classLoaderModel.getParametrizedUriModel();
        return gson.toJson((Object)parameterizedClassloaderModel);
    }

    public static File serializeToFile(ClassLoaderModel classLoaderModel, File destinationFolder) {
        File destinationFile = new File(destinationFolder, "classloader-model.json");
        try {
            destinationFile.createNewFile();
            FileWriter writer = new FileWriter(destinationFile.getAbsolutePath());
            writer.write(ClassLoaderModelJsonSerializer.serialize(classLoaderModel));
            ((Writer)writer).close();
            return destinationFile;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create classloader-model.json", e);
        }
    }
}

