/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import org.mule.devkit.model.code.ArrayClass;
import org.mule.devkit.model.code.CodeModel;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;

public final class PrimitiveType
extends Type {
    private final String typeName;
    private final CodeModel owner;
    private final TypeReference wrapperClass;
    private TypeReference arrayClass;

    PrimitiveType(CodeModel owner, String typeName, Class<?> wrapper) {
        this.owner = owner;
        this.typeName = typeName;
        this.wrapperClass = owner.ref(wrapper);
    }

    @Override
    public CodeModel owner() {
        return this.owner;
    }

    @Override
    public String fullName() {
        return this.typeName;
    }

    @Override
    public String name() {
        return this.fullName();
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public TypeReference array() {
        if (this.arrayClass == null) {
            this.arrayClass = new ArrayClass(this.owner, this);
        }
        return this.arrayClass;
    }

    @Override
    public TypeReference boxify() {
        return this.wrapperClass;
    }

    @Override
    public Type unboxify() {
        return this;
    }

    public TypeReference getWrapperClass() {
        return this.boxify();
    }

    public GeneratedExpression wrap(GeneratedExpression exp) {
        return ExpressionFactory._new(this.boxify()).arg(exp);
    }

    public GeneratedExpression unwrap(GeneratedExpression exp) {
        return exp.invoke(this.typeName + "Value");
    }

    @Override
    public void generate(Formatter f) {
        f.p(this.typeName);
    }
}

