/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.mule.devkit.model.code.AbstractExpression;
import org.mule.devkit.model.code.AnnotationArrayMember;
import org.mule.devkit.model.code.AnnotationStringValue;
import org.mule.devkit.model.code.AnnotationValue;
import org.mule.devkit.model.code.CodeModel;
import org.mule.devkit.model.code.EnumConstant;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;

public final class GeneratedAnnotationUse
extends AnnotationValue {
    private final TypeReference clazz;
    private Map<String, AnnotationValue> memberValues;

    GeneratedAnnotationUse(TypeReference clazz) {
        this.clazz = clazz;
    }

    public TypeReference getAnnotationClass() {
        return this.clazz;
    }

    public Map<String, AnnotationValue> getAnnotationMembers() {
        return Collections.unmodifiableMap(this.memberValues);
    }

    private CodeModel owner() {
        return this.clazz.owner();
    }

    private void addValue(String name, AnnotationValue annotationValue) {
        if (this.memberValues == null) {
            this.memberValues = new LinkedHashMap<String, AnnotationValue>();
        }
        this.memberValues.put(name, annotationValue);
    }

    public GeneratedAnnotationUse param(String name, boolean value) {
        this.addValue(name, new AnnotationStringValue(ExpressionFactory.lit(value)));
        return this;
    }

    public GeneratedAnnotationUse param(String name, byte value) {
        this.addValue(name, new AnnotationStringValue(ExpressionFactory.lit(value)));
        return this;
    }

    public GeneratedAnnotationUse param(String name, char value) {
        this.addValue(name, new AnnotationStringValue(ExpressionFactory.lit(value)));
        return this;
    }

    public GeneratedAnnotationUse param(String name, double value) {
        this.addValue(name, new AnnotationStringValue(ExpressionFactory.lit(value)));
        return this;
    }

    public GeneratedAnnotationUse param(String name, float value) {
        this.addValue(name, new AnnotationStringValue(ExpressionFactory.lit(value)));
        return this;
    }

    public GeneratedAnnotationUse param(String name, long value) {
        this.addValue(name, new AnnotationStringValue(ExpressionFactory.lit(value)));
        return this;
    }

    public GeneratedAnnotationUse param(String name, short value) {
        this.addValue(name, new AnnotationStringValue(ExpressionFactory.lit(value)));
        return this;
    }

    public GeneratedAnnotationUse param(String name, int value) {
        this.addValue(name, new AnnotationStringValue(ExpressionFactory.lit(value)));
        return this;
    }

    public GeneratedAnnotationUse param(String name, String value) {
        this.addValue(name, new AnnotationStringValue(ExpressionFactory.lit(value)));
        return this;
    }

    public GeneratedAnnotationUse annotationParam(String name, Class<? extends Annotation> value) {
        GeneratedAnnotationUse annotationUse = new GeneratedAnnotationUse(this.owner().ref(value));
        this.addValue(name, annotationUse);
        return annotationUse;
    }

    public GeneratedAnnotationUse param(String name, final Enum<?> value) {
        this.addValue(name, new AnnotationValue(){

            @Override
            public void generate(Formatter f) {
                f.t(GeneratedAnnotationUse.this.owner().ref(value.getDeclaringClass())).p('.').p(value.name());
            }
        });
        return this;
    }

    public GeneratedAnnotationUse param(String name, EnumConstant value) {
        this.addValue(name, new AnnotationStringValue(value));
        return this;
    }

    public GeneratedAnnotationUse param(String name, final Class<?> value) {
        this.addValue(name, new AnnotationStringValue(new AbstractExpression(){

            @Override
            public void generate(Formatter f) {
                f.p(value.getName().replace('$', '.'));
                f.p(".class");
            }
        }));
        return this;
    }

    public GeneratedAnnotationUse param(String name, Type type) {
        TypeReference c = type.boxify();
        this.addValue(name, new AnnotationStringValue(c.dotclass()));
        return this;
    }

    public GeneratedAnnotationUse param(String name, GeneratedExpression value) {
        this.addValue(name, new AnnotationStringValue(value));
        return this;
    }

    public AnnotationArrayMember paramArray(String name) {
        AnnotationArrayMember arrayMember = new AnnotationArrayMember(this.owner());
        this.addValue(name, arrayMember);
        return arrayMember;
    }

    public GeneratedAnnotationUse annotate(Class<? extends Annotation> clazz) {
        GeneratedAnnotationUse annotationUse = new GeneratedAnnotationUse(this.owner().ref(clazz));
        return annotationUse;
    }

    @Override
    public void generate(Formatter f) {
        f.p('@').g(this.clazz);
        if (this.memberValues != null) {
            f.p('(');
            boolean first = true;
            if (this.isOptimizable()) {
                f.g(this.memberValues.get("value"));
            } else {
                for (Map.Entry<String, AnnotationValue> mapEntry : this.memberValues.entrySet()) {
                    if (!first) {
                        f.p(',');
                    }
                    f.p(mapEntry.getKey()).p('=').g(mapEntry.getValue());
                    first = false;
                }
            }
            f.p(')');
        }
    }

    private boolean isOptimizable() {
        return this.memberValues.size() == 1 && this.memberValues.containsKey("value");
    }
}

